<?php // $Id: index.php,v 20.12 2004/01/11 10:45:02 EllselAn Exp $
/************************************************************************/
/* KalenderMx v1.3                                                      */
/* ===================                                                  */
/*  Calendar Module for vkpMx 2.x & phpNuke 5.5-7.0                     */
/*  Copyright (c) 2004 by A.Ellsel (kalender@pragmamx.org)              */
/*  http://www.pragmamx.org & http://ww.shiba-design.de                 */
/* -------------------------------------------------------------------- */
/* KalenderMx is based on EventCalendar 2.0                             */
/*  Copyright (c) 2001 Originally by Rob Sutton                         */
/*  http://smart.xnettech.net (Nuke Site)                               */
/*  Development continued by Aleks A.-Lessmann                          */
/* Included some ideas and changes by:                                  */
/*  flobee, bulli-frank, kicks, kochloeffel, FrankySz, Jubilee          */
/* -------------------------------------------------------------------- */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 or a newer version.   */
/************************************************************************/
if (eregi(basename(__file__), $_SERVER["PHP_SELF"])) die ("classement: You can't access this file directly...");

if (!defined("CAL_MODULE_NAME")) define("CAL_MODULE_NAME",basename(dirname(__FILE__)));
if (!defined("CAL_MODULE_PATH")) define("CAL_MODULE_PATH","modules/".CAL_MODULE_NAME."/");

if (!isset($calconf))             include(CAL_MODULE_PATH."config/config.php");
if (!defined("CAL_TABLE_EVENTS")) include_once(CAL_MODULE_PATH."includes/functions.php");
get_lang(CAL_MODULE_NAME);

global $popupwidth, $popupdelay;

#########################################################################################
function calBuiltNextEventsList($req){
  global $dbi, $calconf;
	extract($req);
	if (!isset($caldotcolor)) $caldotcolor = calGetDotColors();
	include(CAL_MODULE_PATH."config/configcolors.php");
	setlocale (LC_TIME, _CALLOCALE);
	$calIsAdmin=calIsAdmin();
	
	$icount = 0;
	$qrydate = "$y-$m-$d";
	$qrycat = (empty($col)) ? calGetSqlEventpoints() : calGetSqlEventpoints($col);
	
	$qryexclude = "";
	if (isset($xnext)) {
		$xnext = base64_decode($xnext);
		$xnext = (is_numeric(str_replace(',','',$xnext))) ? $xnext : 0; // sql_inject check
		$qryexclude = ((int)$xnext) ? " AND eid NOT in(".$xnext.")" : "";
		}
	
	if (isset($xprev)) {
		$xprev = base64_decode($xprev);
		$xprev = (is_numeric(str_replace(',','',$xprev))) ? $xprev : 0; // sql_inject check
		$qryexclude = ((int)$xprev) ? " AND eid NOT in(".$xprev.")" : "";
		$qry="SELECT startDate
		FROM ".CAL_TABLE_EVENTS."
		WHERE (startDate<='$qrydate' or endDate<='$qrydate') and categorie in($qrycat) AND activ=1 $qryexclude 
		ORDER BY startDate DESC, endDate DESC
		limit 0,".$calconf['listcount']."";
		#print "<br>$qry<br>";
		$result=sql_query($qry, $dbi);
		// bis zum letzten Datensatz, der mit dem niedrigsten Datum
		while (list($dbqrydate) = sql_fetch_row($result, $dbi)) {
			if (!empty($dbqrydate)) $yqrydate[] = $dbqrydate;
			}
		
		if (empty($yqrydate)) {
			$noevents = 1;
			}
		else {
			$qrydate = end($yqrydate);
			$arrdateStart = explode("-",$qrydate);
			$y = $arrdateStart[0];
			$m = $arrdateStart[1];
			$d = $arrdateStart[2];
			}
		}
	
	$reqdate = mktime(0, 0, 0, $m, $d, $y);
	$curdate = ("$y$m$d" == Date("Ymd")) ? _CALTODAY : strftime(_CALSHORTDATEFORMAT, $reqdate);
	$linkdate = "&d=$d&m=$m&y=$y";
	
	if (empty($noevents)) {
		$whereoption = "(startDate>='$qrydate' or endDate>='$qrydate') and categorie in($qrycat) AND activ=1 $qryexclude";
		#print "<br>$qrydate<br>";
		$timebreak = ($calconf['listBrTime']) ? "<br>" : "";
		$icolor = 0;
		$imgprops= "align=\"absmiddle\" hspace=\"6\" vspace=\"4\" width=\"9\" height=\"9\" border=\"0\"";
		$listtablecellspacing = (calIsPrintView()) ? 0 : $listtablecellspacing;
		$listout = "<table class=\"tblistview\" width=\"100%\" border=\"$listtableborder\" cellspacing=\"$listtablecellspacing\" cellpadding=\"$listtablecellpadding\" bgcolor=\"$listbordercolor\" bordercolor=\"$listbordercolor\">";
		if (!calIsPrintView()) {
			if ($calconf['listEnddate']) {
				$listout .= "<tr bgcolor=\"$listheadbgcolor\"><td colspan=\"3\" width=\"25%\"><font color=\"$listheadtxtcolor\" class=\"content\"><b>"._CALEVENTDATETEXT."</b></font></td><td width=\"75%\"><font color=\"$listheadtxtcolor\" class=\"content\"><b>"._CALSUBTITLE."</b></font></td></tr>";
				}
			else {
				$listout .= "<tr bgcolor=\"$listheadbgcolor\"><td width=\"10%\"><font color=\"$listheadtxtcolor\" class=\"content\"><b>"._CALEVENTDATETEXT."</b></font></td><td width=\"90%\"><font color=\"$listheadtxtcolor\" class=\"content\"><b>"._CALSUBTITLE."</b></font></td></tr>";
				}
			if ($calconf['ShowPopup']) {
				printOverlibDiv();
				$cal_overlib = new Overlib();
				$cal_overlib -> ol_width = $popupwidth;
				$cal_overlib -> ol_delay = $popupdelay;
				$cal_overlib -> ol_hauto = "True";
				$cal_overlib -> ol_vauto = "True";
				}
			}
		$qry="SELECT eid, aid, title, hometext, topic, informant, year(startDate), month(startDate), dayofmonth(startDate), hour(startTime), minute(startTime), year(endDate), month(endDate), dayofmonth(endDate), hour(endTime), minute(endTime), alldayevent, categorie FROM ".CAL_TABLE_EVENTS." 
		WHERE $whereoption 
		order by startDate, startTime, endDate 
		limit 0,".$calconf['listcount']."";
		#print "<br>$qry<br>";
		$result=sql_query($qry, $dbi);
		while(list($eid, $aid, $title, $hometext, $topic, $informant, $y1, $m1, $d1, $h1, $mi1, $y2, $m2, $d2, $h2, $mi2, $alldayevent, $categorie) = sql_fetch_row($result, $dbi)) {
			$icount++;
			$title = calPrepareDisplay(strip_tags($title));
			$categorie = calGetCurrentEventPoint($categorie);
			$categoriealt = calGetBarColorAlt ($categorie);
			$popuptext = "";
			if (calIsPrintView()) {
				$title = "<b>".$title."</b>";
				$hometext = ($hometext) ? "<br>".$hometext : "";
				}
			else {
				if ($calconf['ShowPopup']) {
					$hometext = ($hometext) ? $categoriealt.":<br>".$hometext : $categoriealt;
					$cal_overlib -> ol_capicon = "".calGetBarImage("ball", $categorie)."";
					$popuptext = $cal_overlib -> vover(calValueToText($hometext),calValueToText($title));
					}
				}
			$excludes[] = $eid; // vor/zurueck Ausschluss
			$timestamp = mktime(0, 0, 0, $m1, $d1, $y1);
			
			$datestampnext = (empty($datestampnext)) ? $timestamp : $datestampnext; 
			$datestampnext = ($datestampnext > $timestamp) ? $datestampnext : $timestamp;
			
			$dateStart = strftime(_CALSHORTDATEFORMAT, $timestamp);
			if ($calconf['listStarttime'] && !$alldayevent) {
				$dateStart.= " $timebreak<span class=\"tiny\">".strftime(_CALTIMEFORMAT, mktime($h1, $mi1, 0, $m1, $d1, $y1))."</span>";
				}
			$dateEnd = strftime(_CALSHORTDATEFORMAT, mktime(0, 0, 0, $m2, $d2, $y2));
			if ($calconf['listEndtime'] && !$alldayevent) {
				if (!$calconf['listEnddate2'] && $m1==$m2 && $d1==$d2 && $y1==$y2) {$dateEnd="";}
				$dateEnd.= " $timebreak<span class=\"tiny\">".strftime(_CALTIMEFORMAT, mktime($h2, $mi2, 0, $m2, $d2, $y2))."</span>";
				}
			$bgcolornew = ($icolor==0) ? $listbgcolor1 : $listbgcolor2;
			$txtcolornew = ($icolor==0) ? $listtxtcolor1 : $listtxtcolor2;
			$icolor = ($icolor==0) ? 1 : 0;
			$listout .= "<tr valign='top'>";
			if ($calconf['listEnddate']) {
				$listout .= "<td nowrap class='tdlistview'><font color=\"$txtcolornew\" class=\"content\">$dateStart</font></td>";
				$listout .= "<td align='center' class='tdlistview'><font color=\"$txtcolornew\" class=\"tiny\">"._CALLISTRANGE."</font></td>";
				$listout .= "<td nowrap class='tdlistview'><font color=\"$txtcolornew\" class=\"content\">$dateEnd</font></td>";
				}
			else {
				$listout .= "<td nowrap class='tdlistview'><font color=\"$txtcolornew\" class=\"content\">$dateStart</font></td>";
				}
			$listout .= "<td class='tdlistview'><font color=\"$txtcolornew\" class=\"content\">";
			if ($calIsAdmin && !calIsPrintView()){
				$listout .= "<a href=\"admin.php?op=CalendarDeleteEvent&eid=$eid\"><img src=\"".CAL_IMAGE_PATH."delete.gif\" alt=\""._CALDELETESTORY."\" width=\"20\" height=\"16\" border=\"0\" align=\"right\"></a>";
				$listout .= "<a href=\"admin.php?op=CalendarEditEvent&eid=$eid\"><img src=\"".CAL_IMAGE_PATH."edit.gif\" alt=\""._EDIT."\" width=\"19\" height=\"17\" border=\"0\" align=\"right\"></a>";
				}
			$listout .= "<img src=\"".calGetBarImage("ball",$categorie)."\" alt=\"".$categoriealt."\" title=\"".$categoriealt."\" ".$imgprops.">&nbsp;";
			$listout .= "<a href=\"".CAL_MODULE_LINK."&op=view&eid=".$eid."\" ".$popuptext.">".$title."</a></font>";
			if (calIsPrintView()) {
				$listout .= $hometext;
				}
			$listout .= "</td></tr>";
			}
		$listout .= "</table>";
		}
	
	$icount = (empty($icount)) ? 0 : $icount;
	if (empty($icount)) {
		$listout = "<br><br><b>"._CAL0EVENTS."</b><br><br>";
		}

	calBuildModusselectors($op, $d, $m, $y);
	echo "<br>";
	OpenTable();
	echo "<center><font class=\"title\"><b>"._CALLISTDESCRIPTION1." $icount&nbsp;"._CALLISTDESCRIPTION2.", "._CALLISTSTART." $curdate.</b></font></center><br>\n";
	echo calBuildColorLegend("legend", 1, 0, $col, $linkdate);
	echo "<br>";
	
	echo $listout;
	
	if (!calIsPrintView()) {
		$nexttext = "".$calconf['listcount']." "._CALNAVINEXT."<img src=\"".CAL_IMAGE_PATH."next.gif\" width=\"16\" height=\"14\" border=\"0\" hspace=\"5\" alt=\"".$calconf['listcount']." "._CALNAVINEXT."\">";
		$prevtetx = "<img src=\"".CAL_IMAGE_PATH."back.gif\" width=\"16\" height=\"14\" border=\"0\" hspace=\"5\" alt=\"".$calconf['listcount']." "._CALNAVIPREV."\">".$calconf['listcount']." "._CALNAVIPREV."";
		$excludi = (isset($excludes)) ? base64_encode(implode(",",$excludes)) : "";
		if ($icount >= $calconf['listcount'] || isset($xprev)){
			$dnext = (empty($datestampnext)) ? $d : (int)Date("d", $datestampnext);
			$mnext = (empty($datestampnext)) ? $m : (int)Date("m", $datestampnext);
			$ynext = (empty($datestampnext)) ? $y : (int)Date("Y", $datestampnext);
			$navinext = "<a href=\"".CAL_MODULE_LINK."&op=list&d=$dnext&m=$mnext&y=$ynext&col=$col&xnext=$excludi#caltop\">$nexttext</a>";
			}
		else {
			$navinext = $nexttext;
			}
		if (!empty($icount) || isset($xnext) || (empty($icount) && !isset($xprev))) {
			$naviprev = "<a href=\"".CAL_MODULE_LINK."&op=list&d=$d&m=$m&y=$y&col=$col&xprev=$excludi#caltop\">$prevtetx</a>";
			}
		else {
			$naviprev = $prevtetx;
			}
		
		echo "\n<table width=\"100%\" border=\"0\" cellpadding=\"3\" cellspacing=\"0\">\n<tr>\n";
		echo "<TD nowrap><FONT class=\"content\">$naviprev &nbsp;|&nbsp; $navinext</font></TD>\n";
		echo "<TD align=\"right\" nowrap><br><FONT class=\"content\"><a href=\"http://www.pragmamx.org\" target=\"_blank\" class=\"tiny\" style=\"text-decoration: none; font-weight: lighter;\" title=\"KalenderMx v".CAL_VERSION." by shiba-design.de\"> &AElig;</a></FONT></TD>\n";
		echo "</TR>\n</TABLE>\n";
		
		#echo "<td>";
		#echo "<select name=\"top\">"; calBuildTopicsSelect($topic); echo "</select>";
		#echo "<input type=\"submit\" value=\""._SEARCH."\">";
		#echo "</td>";
		#echo "<td align=\"right\"><br><br>
		#</td>
		#</tr></table>";
		}
	CloseTable();
	setlocale (LC_TIME, $GLOBALS["locale"]);
	}

#########################################################################################
function calBuiltMonth($req) {
	global $dbi, $calconf;#, $op, $caldotcolor;
	extract($req);
	if (!isset($caldotcolor)) $caldotcolor = calGetDotColors();
	include(CAL_MODULE_PATH."config/configcolors.php");
	if (!calDetectGoodBrowser() || calIsPrintView()) {$calconf['TextEvents']=1;}

	/**** Get todays date */
	$Today_d = (int)Date("d");
	$Today_m = (int)Date("m");
	$Today_y = (int)Date("Y");
	
	$pd = mktime(0, 0, 0, $m - 1, $d, $y);
	$Prev_Date="m=".Date("m",$pd)."&d=".Date("d",$pd)."&y=".Date("Y",$pd);
	$var = (Date("Y",$pd)!=$y) ? " ".Date("Y",$pd) : "";
	$Prev_Month = calGetMonthName(Date("m",$pd)).$var;
	
	$nd = mktime(0, 0, 0, $m + 1, $d, $y);
	$Next_Date="m=".Date("m",$nd)."&d=".Date("d",$nd)."&y=".Date("Y",$nd);
	$var = (Date("Y",$nd)!=$y) ? " ".Date("Y",$nd) : "";
	$Next_Month = calGetMonthName(Date("m",$nd)).$var;
	
	$showmonth = calGetMonthName($m)." $y";
	
	/**** Get the Day (Integer) for the first day in the month */
	$First_Day_of_Month_Date = mktime(0, 0, 0, $m, 1, $y);
	$Day_of_First_Week = Date("w",$First_Day_of_Month_Date)-_CALWEEKBEGINN;
	if ($Day_of_First_Week<0) $Day_of_First_Week=6;
	/**** Find the last day of the month */
	$lastday = (int)Date("t",$First_Day_of_Month_Date);
	/**** Set up data */
	
	$picheight=9;
	calBuildModusselectors($op, $d, $m, $y);
	echo "<br>";
	if (!calIsPrintView() && $calconf['ShowPopup']) {
		printOverlibDiv();
		$cal_overlib = new Overlib();
		$cal_overlib -> ol_width = $popupwidth;
		$cal_overlib -> ol_delay = $popupdelay;
		$cal_overlib -> ol_hauto = "True";
		$cal_overlib -> ol_vauto = "True";
		}
	$result = sql_query("SELECT eid,title,hometext,startDate,endDate,categorie FROM ".CAL_TABLE_EVENTS." 
	WHERE (((startDate >= '$y-$m-1' AND startDate <= '$y-$m-$lastday') 
	OR (endDate >= '$y-$m-1' AND endDate <= '$y-$m-$lastday') 
	OR (endDate >= '$y-$m-$lastday' AND startDate <= '$y-$m-1')) 
	AND alldayevent=1) 
	and (categorie in(".calGetSqlEventpoints().")) 
	AND activ=1
	ORDER BY startDate ASC", $dbi);
	$count = -1;
	while(list($arr_eid[], $arr_title[], $arr_hometext[], $arr_startDate[], $arr_endDate[], $arr_categorie[]) = sql_fetch_row($result, $dbi)) {
		$count++;
		}
	/**** Build Month */
	$tdwidth = (int)(100 / 7) ;
	$tblwidth = 7 * $tdwidth;
	OpenTable();
	echo "<center>";
	echo "\n<table width=\"100%\" border=\"0\" cellpadding=\"3\" cellspacing=\"0\">\n<tr valign=\"top\">";
	if (!calIsPrintView()) echo "<TD width=\"25%\" nowrap><a href=\"".CAL_MODULE_LINK."&$Prev_Date&op=month\"><FONT class=\"content\"><img src=\"".CAL_IMAGE_PATH."back.gif\" alt=\"".$Prev_Month."\" width=\"16\" height=\"14\" border=\"0\" hspace=\"5\">".$Prev_Month."</font></a></TD>\n";
	echo "<TD width=\"50%\" align=\"center\" nowrap><FONT class=\"title\"><b>".$showmonth."</b></FONT></TD>\n";
	if (!calIsPrintView()) echo "<TD width=\"25%\" align=\"right\" nowrap><a href=\"".CAL_MODULE_LINK."&$Next_Date&op=month\"><FONT class=\"content\">".$Next_Month."<img src=\"".CAL_IMAGE_PATH."next.gif\" alt=\"".$Next_Month."\" width=\"16\" height=\"14\" border=\"0\" hspace=\"5\"></font></a></TD>\n";
	echo "</TR>\n</TABLE>\n";
	echo "<table bgcolor=\"$monthtablebgcolor\" border=\"0\" cellspacing=\"1\" cellpadding=\"0\" width=\"${tblwidth}%\" class=\"tbmonthview\">";
	$day_of_week = 1;

	echo "<TR bgcolor=\"$monthheadbgcolor\">
		<TH width=\"$tdwidth%\" class=\"thmonthview\"><FONT color=\"$monthheadtxtcolor\" class=\"content\">"._CALFIRSTDAY."</font></TH>
		<TH width=\"$tdwidth%\" class=\"thmonthview\"><FONT color=\"$monthheadtxtcolor\" class=\"content\">"._CALSECONDDAY."</font></TH>
		<TH width=\"$tdwidth%\" class=\"thmonthview\"><FONT color=\"$monthheadtxtcolor\" class=\"content\">"._CALTHIRDDAY."</font></TH>
		<TH width=\"$tdwidth%\" class=\"thmonthview\"><FONT color=\"$monthheadtxtcolor\" class=\"content\">"._CALFOURTHDAY."</font></TH>
		<TH width=\"$tdwidth%\" class=\"thmonthview\"><FONT color=\"$monthheadtxtcolor\" class=\"content\">"._CALFIFTHDAY."</font></TH>
		<TH width=\"$tdwidth%\" class=\"thmonthview\"><FONT color=\"$monthheadtxtcolor\" class=\"content\">"._CALSIXTHDAY."</font></TH>
		<TH width=\"$tdwidth%\" class=\"thmonthview\"><FONT color=\"$monthheadtxtcolor\" class=\"content\">"._CALSEVENTHDAY."</font></TH>
	</TR>";

	/**** Previous Greyed month days */
	While ($day_of_week < ($Day_of_First_Week + 1)) {
		if ($day_of_week == 1) {
			echo "\n<TR valign=\"top\">";
			}
		$Tmp_Date = mktime(0, 0, 0, $m, 1 - (($Day_of_First_Week + 1) - $day_of_week), $y);
		$Tmp_Day = Date("d",$Tmp_Date);
		echo "<TD bgcolor=\"$monthshadedbgcolor\" align=\"center\" height=\"$monthdayheigth\" class=\"tdmonthview2\"><FONT color=$monthshadedtextcolor class=\"content\">$Tmp_Day</font></TD>";
		$day_of_week += 1;
		}
	$usedcount = 0;
	$cellcount = 0;
	/**** Build Current Month */
	for ($day = 1 ; $day <= $lastday ; $day++) {
		if ($day_of_week == 1) {
			echo "\n<TR valign=\"top\">";
			}
		$xDate = mktime(0, 0, 0, $m, $day, $y);
		$xday=getdate($xDate);
		if (($day == $Today_d) && ($m == $Today_m) && ($y == $Today_y)) {
			$bcol=$monthcurdaybgcolor; $tcol=$monthcurdaytxtcolor;
			}
		else if ($xday["weekday"]=="Sunday") {
			$bcol=$monthsundaybgcolor; $tcol=$monthsundaytxtcolor;
			}
		else {
			$bcol=$monthbgcolor; $tcol=$monthtextcolor;
			}
		echo "\n<TD height=\"$monthdayheigth\" bgcolor=\"$bcol\" class=\"tdmonthview1\"><center><a href=\"".CAL_MODULE_LINK."&m=$m&d=$day&y=$y&op=day\"><font color=\"$tcol\" class=\"content\"><b>$day</b></font></a></center>";
		/************************/
		/**** SET UP DATA!!! ****/
		/************************/
		/**** Reset Cell Array */
		$cellDate = mktime (0, 0, 0, $m, $day, $y);
		for ($i=0;$i <= $cellcount - 1;$i++) {
			$tmpEndDate_Array = explode("-", $cellArrayEndDate[$i]);
			$tmpEndDate = mktime (0, 0, 0, $tmpEndDate_Array[1], $tmpEndDate_Array[2], $tmpEndDate_Array[0]);
			if ($tmpEndDate < $cellDate) {
				$cellArray[$i] = "FALSE";
				}
			}
		/**** Clean out Cell Array */
		if ($cellcount != 0) {
			$j = $cellcount;
			for ($i=$cellcount - 1;$i >= 0;$i--) {
				if ($cellArray[$i] == "FALSE") {
					Array_pop($cellArray);
					Array_pop($cellArrayTitle);
					Array_pop($cellArrayEventDate);
					Array_pop($cellArrayEndDate);
					Array_pop($cellArrayBarColor);
					Array_pop($cellArrayDesc);
					$j--;
					}
				else {
					break;
					}
				}
			$cellcount = $j;
			}
		/**** Add neccessary additions to cellArray */
		if (isset($arr_startDate[$usedcount])){
			while ((strtotime($arr_startDate[$usedcount]) <= strtotime("$y-$m-$day")) && ($usedcount <= $count)) {
				$added = "FALSE";
				/**** First Try to find a spot in the cell for the event */
				for ($i=0;$i <= $cellcount - 1;$i++) {
					if ($cellArray[$i] == "FALSE") {
						/**** Found spot in cellArray */
						$cellArray[$i] = $arr_eid[$usedcount];
						$cellArrayTitle[$i] = $arr_title[$usedcount];
						$cellArrayEventDate[$i] = $arr_startDate[$usedcount];
						$cellArrayEndDate[$i] = $arr_endDate[$usedcount];
						$cellArrayBarColor[$i] = $arr_categorie[$usedcount];
						$cellArrayDesc[$i] = $arr_hometext[$usedcount];
						$added = "TRUE";
						break 1;
						}
					}
				/**** If all spots are taken in the current cellArray then add it to the end */
				if ($added == "FALSE") {
					$cellArray[] = $arr_eid[$usedcount];
					$cellArrayTitle[] = $arr_title[$usedcount];
					$cellArrayEventDate[] = $arr_startDate[$usedcount];
					$cellArrayEndDate[] = $arr_endDate[$usedcount];
					$cellArrayBarColor[] = $arr_categorie[$usedcount];
					$cellArrayDesc[] = $arr_hometext[$usedcount];
					$cellcount++;  /**** Increase cell count since added to the end of the array */
					}
				$usedcount++;
				if (empty($arr_startDate[$usedcount])) break;
				}
			}
		/**************************************/
		/**** INSERT DATA INTO CALENDAR!!! ****/
		/**************************************/
		for ($i=0; $i<=$cellcount - 1; $i++) {
			$categorie = calGetCurrentEventPoint($cellArrayBarColor[$i]);
			$popuptext = "";
			if (!calIsPrintView() && $calconf['ShowPopup']) {
				$categoriealt = calGetBarColorAlt($categorie);
				$poptitle = calValueToText($cellArrayTitle[$i]);
				$poptext = ($cellArrayDesc[$i]) ? calValueToText("$categoriealt:<br>$cellArrayDesc[$i]") : calValueToText($categoriealt);
				$cal_overlib -> ol_capicon = "".calGetBarImage("ball", $categorie)."";
				$popuptext = $cal_overlib -> vover($poptext,$poptitle);
				}
			if (!$calconf['TextEvents']) {
				echo "<table width=\"100%\" cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr $popuptext>";
				}

			if ($cellArray[$i] != "FALSE") {
				$link="".CAL_MODULE_LINK."&op=view&eid=$cellArray[$i]";
				$tmpEventDate_Array = explode("-", $cellArrayEventDate[$i]);
				$tmpEventDate = mktime (0, 0, 0, $tmpEventDate_Array[1], $tmpEventDate_Array[2], $tmpEventDate_Array[0]);
				$tmpEndDate_Array = explode("-", $cellArrayEndDate[$i]);
				$tmpEndDate = mktime (0, 0, 0, $tmpEndDate_Array[1], $tmpEndDate_Array[2], $tmpEndDate_Array[0]);
				if ($calconf['TextEvents']) {
					echo "<img src=\"".calGetBarImage("ball",$categorie)."\" height=\"".$picheight."\" width=\"".$picheight."\" border=\"0\" hspace=\"2\"><a href=\"$link\" $popuptext><font class=\"tiny\">".$cellArrayTitle[$i]."</font></a><br>";
					}
				else {
					if (($cellDate == $tmpEndDate) && ($tmpEndDate == $tmpEventDate)) {
						echo "<td height=\"".$picheight."\"><a href=\"$link\"><img src=\"".calGetBarImage("leftbar",$categorie)."\" height=\"".$picheight."\" width=\"40\" border=\"0\"></a></td><td align=\"left\" width=\"100%\" background=\"".calGetBarImage("mainbar",$categorie)."\"><a href=\"$link\"><img src=\"".calGetBarImage("mainbar",$categorie)."\" height=\"".$picheight."\" width=\"100%\" border=\"0\"></a></td><td align=\"right\"><img src=\"".calGetBarImage("rightbarcap",$categorie)."\" height=\"".$picheight."\" width=\"5\" border=\"0\"></td>";
						}
					elseif ($cellDate == $tmpEventDate) {
						echo "<td height=\"".$picheight."\"><a href=\"$link\"><img src=\"".calGetBarImage("leftbar",$categorie)."\" height=\"".$picheight."\" width=\"40\" border=\"0\"></a></td><td align=\"left\" width=\"100%\" background=\"".calGetBarImage("mainbar",$categorie)."\"><a href=\"$link\"><img src=\"".calGetBarImage("mainbar",$categorie)."\" height=\"".$picheight."\" width=\"100%\" border=\"0\"></a></td>";
						}
					elseif ($cellDate == $tmpEndDate) {
						echo "<td align=\"right\" width=\"100%\" background=\"".calGetBarImage("mainbar",$categorie)."\" height=\"".$picheight."\"><a href=\"$link\"><img src=\"".calGetBarImage("mainbar",$categorie)."\" height=\"".$picheight."\" width=\"100%\" border=\"0\"></a></td><td><a href=\"$link\"><img src=\"".calGetBarImage("rightbar",$categorie)."\" height=\"".$picheight."\" width=\"40\" border=\"0\"></a></td>";
						}
					else {
						if ($day == 1) {
							echo "<td height=\"".$picheight."\"><a href=\"$link\"><img src=\"".calGetBarImage("leftbar",$categorie)."\" height=\"".$picheight."\" width=\"40\" border=\"0\"></a></td><td align=\"left\" width=99% background=\"".calGetBarImage("mainbar",$categorie)."\"><a href=\"$link\"><img src=\"".calGetBarImage("mainbar",$categorie)."\" height=\"".$picheight."\" width=\"100%\" border=\"0\"></a></td>";
							}
						else {
							echo "<td align=\"center\" background=\"".calGetBarImage("mainbar",$categorie)."\" height=\"".$picheight."\"><a href=\"$link\"><img src=\"".calGetBarImage("mainbar",$categorie)."\" height=\"".$picheight."\" width=\"100%\" border=\"0\"></a></td>";
							}
						}
					}
				}
			else {
				if (!$calconf['TextEvents']) {
					echo "<td width=\"100%\"><img src=\"".CAL_IMAGE_PATH."blankbar.gif\" height=\"".$picheight."\" border=0></td>";
					}
				}
			if (!$calconf['TextEvents']) {
				echo "</tr></table>";
				}
			}
		$cevents = 0;
		$onedayevents = ($calconf['TextEvents']) ? "" : "<table width=\"100%\" border=\"0\" cellspacing=\"0\" cellpadding=\"1\">";
		$resultAPPT = sql_query("SELECT eid,title,hometext,startDate,endDate,startTime,endTime,categorie FROM ".CAL_TABLE_EVENTS." 
		WHERE (startDate <= '$y-$m-$day' 
		AND endDate >= '$y-$m-$day' 
		AND alldayevent='0') 
		and (categorie in(".calGetSqlEventpoints().")) 
		AND activ=1
		ORDER BY startTime, endTime ASC", $dbi);
		while(list($eid, $title, $hometext, $startDate, $endDate, $startTime, $endTime, $categorie) = sql_fetch_row($resultAPPT, $dbi)) {
			$cevents ++;
			$title = strip_tags($title);
			#$hometext = calPrepareDisplay($hometext);
			$startTime = calGetTime($startTime);
			$endTime = ($startDate != $endDate) ? "" : "-".calGetTime($endTime);
			$categorie = calGetCurrentEventPoint($categorie);
			$popuptext = "";
			if (!calIsPrintView() && $calconf['ShowPopup']) {
				$categoriealt = calGetBarColorAlt($categorie);
				$poptitle = calValueToText($title);
				$poptext = ($hometext) ? calValueToText("$categoriealt:<br>$hometext") : calValueToText($categoriealt);
				$cal_overlib -> ol_capicon = "".calGetBarImage("ball", $categorie)."";
				$popuptext = $cal_overlib -> vover($poptext,$poptitle);
				}
			if ($calconf['TextEvents']) {
				$onedayevents .= "<a href=\"".CAL_MODULE_LINK."&op=view&eid=$eid\" $popuptext>";
				$onedayevents .= "<img src=\"".calGetBarImage("ball",$categorie)."\" height=\"".$picheight."\" width=\"".$picheight."\" border=\"0\" hspace=\"2\">";
				$onedayevents .= "<font class=\"tiny\">".$startTime.$endTime."<br>$title</font></a><br>";
				}
			else {
				$onedayevents .= "<tr $popuptext valign=\"top\"><td width=\"".$picheight."\"><img src=\"".calGetBarImage("ball",$categorie)."\" height=\"".$picheight."\" width=\"".$picheight."\" border=\"0\" vspace=\"3\"></td>";
				$onedayevents .= "<td><a href=\"".CAL_MODULE_LINK."&op=view&eid=$eid\">";
				$onedayevents .= "<font class=\"tiny\">".$startTime.$endTime."<br>".calPrepareDisplay($title)."</font></a></td></tr>";
				}
			}
		$onedayevents .= ($calconf['TextEvents']) ? "" : "</table>";
		if ($cevents) echo $onedayevents;
		
		echo "<br></td>";
		if ($day_of_week == 7) {
			$day_of_week = 0;
			echo "\n</TR>";
			}
		$day_of_week += 1;
		}
	/**** Next Greyed month days */
	$day = 1;
	While (($day_of_week <= 7) && ($day_of_week != 1)) {
		echo "<TD bgcolor=$monthshadedbgcolor align=\"center\" class=\"tdmonthview2\"><FONT color=$monthshadedtextcolor class=\"content\">$day</font></TD>";
		$day_of_week += 1;
		$day += 1;
		}
	echo "\n</TR>\n</TABLE><br>";
	echo "<div align=\"center\" style=\"width: ${tblwidth}%;\">";
	echo calBuildColorLegend("legend");
	echo "</div>";
	echo "</center>";
	CloseTable();
	}

#########################################################################################
function calBuiltDay($req) {
  global $calconf, $dbi;#, $op;
	include(CAL_MODULE_PATH."config/configcolors.php");
	setlocale (LC_TIME, _CALLOCALE);
	extract($req);
	$pd = mktime(0, 0, 0, $m, $d - 1, $y);
	$Prev_Date="m=".Date("m",$pd)."&d=".Date("d",$pd)."&y=".Date("Y",$pd);
	$nd = mktime(0, 0, 0, $m, $d + 1, $y);
	$Next_Date="m=".Date("m",$nd)."&d=".Date("d",$nd)."&y=".Date("Y",$nd);
	calBuildModusselectors($op, $d, $m, $y);
	if (!calIsPrintView() && $calconf['ShowPopup']) {
		printOverlibDiv();
		$cal_overlib = new Overlib();
		$cal_overlib -> ol_width = $popupwidth;
		$cal_overlib -> ol_delay = $popupdelay;
		$cal_overlib -> ol_hauto = "True";
		$cal_overlib -> ol_vauto = "True";
		}
	echo "<br>";
	OpenTable();
	echo "\n<table width=\"100%\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\">\n<TR>";
	/**** Print Previous Day Button */
	if (!calIsPrintView()) echo "\n<TD width=\"100\"><a href=\"".CAL_MODULE_LINK."&$Prev_Date&op=day\"><font class=\"content\"><img src=\"".CAL_IMAGE_PATH."back.gif\" alt=\""._CALPREVIOUS."\" width=\"16\" height=\"14\" border=\"0\" hspace=\"5\">"._CALPREVIOUS."</font></a></TD>";
	/**** Print Month Name and Year */
	echo "\n<TD align=\"center\"><font class=\"title\"><b>";
	echo strftime(_CALLONGDATEFORMAT, mktime(0, 0, 0, $m, $d, $y));
	echo "</b></font></TD>";
	/**** Print Next Day Button */
	if (!calIsPrintView()) echo "\n<TD width=\"100\" align=\"right\"><a href=\"".CAL_MODULE_LINK."&$Next_Date&op=day\"><font class=\"content\">"._CALNEXT."<img src=\"".CAL_IMAGE_PATH."next.gif\" alt=\""._CALNEXT."\" width=\"16\" height=\"14\" border=\"0\" hspace=\"5\"></font></a></TD>";
	echo "\n</TR>\n</TABLE><br>";
	echo "\n<TABLE border=\"0\" cellspacing=\"1\" cellpadding=\"6\" width=\"100%\" bgcolor=\"$bgcolor2\" class=\"tbdayview\">\n<TR>";
	/**** Appointments */
	echo "\n<TD width=\"50%\" valign=\"top\" bgcolor=\"$daybgcolor\" class=\"tbdayview\">";
	echo "\n<TABLE width=\"100%\" bgcolor=\"$dayevebgcolor\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\"><TR><TD bgcolor=\"$dayappbgcolor\"><FONT color=\"$dayapptxtcolor\" class=\"content\"><b>"._CALHEADAPPOINTM."</b></font></TD></TR></TABLE>";
	echo "\n<FONT COLOR=\"$dayshadetextcolor\" class=\"content\">"._CALDAYMORNING."</FONT>";
	$qry = "SELECT eid, title, hometext, startDate, startTime, endDate, endTime, categorie FROM ".CAL_TABLE_EVENTS." 
	WHERE (startDate<='$y-$m-$d' 
	AND endDate >='$y-$m-$d' 
	AND alldayevent='0' 
	AND startTime < '".$calconf['TimeArray'][0]."') 
	AND activ=1
	ORDER BY startTime, endTime ASC";
	calPrintAppt($qry, $daytextcolor);
	$i = 0;
	while ($calconf['TimeArray'][$i]) {
		calAddTimeRange($calconf['TimeArray'][$i],$calconf['TimeArray'][$i+1],$y,$m,$d,$daytextcolor);
		$i++;
		if (!isset($calconf['TimeArray'][$i+1])) {
			break;
			}
		}
	echo "\n<br><br><FONT COLOR=\"$dayshadetextcolor\" class=\"content\">"._CALDAYEVENING."</FONT>";
	$qry = "SELECT eid, title, hometext, startDate, startTime, endDate, endTime, categorie FROM ".CAL_TABLE_EVENTS." 
	WHERE (startDate<='$y-$m-$d' 
	AND endDate >= '$y-$m-$d' 
	AND alldayevent='0' 
	AND startTime >= '".$calconf['TimeArray'][$i]."') 
	and (categorie in(".calGetSqlEventpoints().")) 
	AND activ=1
	ORDER BY startTime, endTime ASC;";
	calPrintAppt($qry, $daytextcolor);
	echo "\n</TD>";
	
	/**** Events */
	echo "\n<TD width=\"50%\" valign=\"top\" bgcolor=\"$daybgcolor\" class=\"tbdayview\">";
	echo "\n<TABLE width=\"100%\" bgcolor=\"$dayappbgcolor\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\"><TR><TD bgcolor=\"$dayevebgcolor\"><FONT color=\"$dayevetxtcolor\" class=\"content\"><b>"._CALDAYEVENTS."</b></font></TD></TR></TABLE>";
	$result = sql_query("SELECT eid,title,categorie,hometext FROM ".CAL_TABLE_EVENTS." 
	WHERE (startDate <= '$y-$m-$d' 
	AND endDate >= '$y-$m-$d' 
	AND alldayevent='1') 
	and (categorie in(".calGetSqlEventpoints().")) 
	AND activ=1 
	ORDER BY title ASC", $dbi);
	$out1 = "";
	while(list($eid, $title, $categorie, $hometext) = sql_fetch_row($result, $dbi)) {
		$title = calPrepareDisplay(strip_tags($title));
		$categorie = calGetCurrentEventPoint($categorie);
		$popuptext = "";
		if (!calIsPrintView() && $calconf['ShowPopup']) {
			$categoriealt = calGetBarColorAlt($categorie);
			$poptitle = calValueToText($title);
			$poptext = ($hometext) ? calValueToText("$categoriealt:<br>".$hometext."") : calValueToText($categoriealt);
			$cal_overlib -> ol_capicon = "".calGetBarImage("ball", $categorie)."";
			$popuptext = $cal_overlib -> vover($poptext,$poptitle);
			}
		$out1 .= "<tr valign='top'>
		<td><img src='".calGetBarImage("ball",$categorie)."' alt='' hspace='3' vspace='3' border='0'></td>
		<td><a href=\"".CAL_MODULE_LINK."&op=view&eid=".$eid."\"".$popuptext.">".$title."</a></td>
		</tr>";
		}
	if ($out1) {
		echo "<table border='0' cellspacing='0' cellpadding='3'>".$out1."</table>";
		}
	echo "\n</TD>\n</TR>";
	echo "\n</TABLE>\n<br>";
	echo calBuildColorLegend("legend");
	CloseTable();
	setlocale (LC_TIME, $GLOBALS["locale"]);
	}

#########################################################################################
function calViewEvent($req) {
  global $dbi;
	extract($req);
	$eid = (int)$eid;
	##$currentmode="calViewEvent";
	$qry="SELECT * FROM ".CAL_TABLE_EVENTS." WHERE eid=$eid AND activ=1";
  $result = sql_query($qry, $dbi);
	$event = sql_fetch_array($result, $dbi);
	$arrtmp=explode("-",$event["startDate"]);
	calBuildModusselectors($op, $arrtmp[2], $arrtmp[1], $arrtmp[0]);
	echo "<br>";
  calEventView($event);
	if (calIsAdmin() && !calIsPrintView()) {
    #echo "<br><center><a href=\"admin.php?op=CalendarEditEvent&eid=$eid\"><img src=\"".CAL_IMAGE_PATH."edit.gif\" alt=\""._EDIT."\" width=\"19\" height=\"17\" border=\"0\"></a> <a href=\"admin.php?op=CalendarRemoveEvent&eid=$eid\"><img src=\"".CAL_IMAGE_PATH."delete.gif\" alt=\""._CALDELETESTORY."\" width=\"20\" height=\"16\" border=\"0\"></a>\n</center>";
    echo "<br><center><a href=\"admin.php?op=CalendarEditEvent&eid=$eid\"><img src=\"".CAL_IMAGE_PATH."edit.gif\" alt=\""._EDIT."\" width=\"19\" height=\"17\" border=\"0\"></a> <a href=\"admin.php?op=CalendarDeleteEvent&eid=$eid\"><img src=\"".CAL_IMAGE_PATH."delete.gif\" alt=\""._CALDELETESTORY."\" width=\"20\" height=\"16\" border=\"0\"></a>\n</center>";
  	}
	}

#########################################################################################
function calBuiltYear($req) {
	global $dbi;#, $op;
	extract($req);
	$qry = "";
	
	include(CAL_MODULE_PATH."config/configcolors.php");
	calBuildModusselectors($op, $d, $m, $y);
	echo "<br>";
	OpenTable();
	$pd = mktime(0, 0, 0, $m, $d, $y - 1);
	$Prev_Date="m=$m&d=$d&y=".Date("Y",$pd);
	$nd = mktime(0, 0, 0, $m, $d, $y + 1);
	$Next_Date="m=$m&d=$d&y=".Date("Y",$nd);
	/**** Get todays date */
	$Today_d = (int)Date("d");
	$Today_m = (int)Date("m");
	$Today_y = (int)Date("Y");
	echo "\n<table width=\"100%\" border=\"0\" cellpadding=\"2\" cellspacing=\"0\">\n<TR>";
	if (!calIsPrintView()) echo "<td width=\"100\"><a href=\"".CAL_MODULE_LINK."&$Prev_Date&op=year\"><font class=\"content\"><img src=\"".CAL_IMAGE_PATH."back.gif\" alt=\""._CALPREVIOUS."\" width=\"16\" height=\"14\" border=\"0\" hspace=\"5\">"._CALPREVIOUS."</font></a></td>";
	echo "<td align=\"center\"><font class=\"title\"><b>$y</b></font></td>";
	if (!calIsPrintView()) echo "<td width=\"100\" align=\"right\"><a href=\"".CAL_MODULE_LINK."&$Next_Date&op=year\"><font class=\"content\">"._CALNEXT."<img src=\"".CAL_IMAGE_PATH."next.gif\" alt=\""._CALNEXT."\" width=\"16\" height=\"14\" border=\"0\" hspace=\"5\"></font></a></TD>";
	echo "</TR>\n</table>";
	echo "<table border=\"0\" cellpadding=\"2\" cellspacing=\"0\" width=\"100%\"><TR>";
	for ($i=1;$i<13;$i++) {
		/**** Get the Day (Integer) for the first day in the month */
		$First_Day_of_Month_Date = mktime(0, 0, 0, $i, 1, $y);
		$Date = $First_Day_of_Month_Date;
		$m = $i;
		$Day_of_First_Week = Date("w",$First_Day_of_Month_Date)-_CALWEEKBEGINN;
		if ($Day_of_First_Week<0) $Day_of_First_Week=6;
		/**** Find the last day of the month */
		$Month = Date("m",$Date);
		$lastday = (int)Date("t",$Date);
		#$day = 27;
		#do {
		#	$End_of_Month_Date = mktime(0, 0, 0, $m, $day, $y);
		#	$Test_Month = Date("m",$End_of_Month_Date);
		#	$day += 1;
		#	} while ( $Month == $Test_Month );
		#$lastday = $day - 2;
		/**** Build Month */
		if (($i == 4) || ($i == 7) || ($i == 10)) {
			echo "</TR><TR><TD colspan=3><br></TD></TR><TR>";
			}
		echo "\n<TD valign=\"top\" align=\"center\">
		<TABLE class=\"tbyearview\" bgcolor=\"$yeartablebgcolor\" border=\"$yeartableborder\" cellspacing=\"$yeartablecellspacing\" cellpadding=\"$yeartablecellpadding\">
		<TR bgcolor=\"$yearheadbgcolor\">\n<td colspan=\"7\" align=\"center\">
		<a href=\"".CAL_MODULE_LINK."&m=$i&d=$d&y=$y&op=month\">
		<FONT color=\"$yearheadtxtcolor\" class=\"content\"><b>". calGetMonthName($i)."</b></FONT></a>
		</td>\n</TR>";
		/**** Previous Greyed month days */
		echo "\n";
		if ($Day_of_First_Week > 0) {
			echo "\n<TR><TD colspan=\"$Day_of_First_Week\" bgcolor=\"$yearshadedbgcolor\">&nbsp;</TD>";
			}
		$day_of_week = $Day_of_First_Week + 1;
		/**** Build Current Year */
		for ($day = 1 ; $day <= $lastday ; $day++) {
			if ($day_of_week == 1) {
				echo "\n<TR>";
				}
			if (($day == $Today_d) && ($m == $Today_m) && ($y == $Today_y)){
				echo "\n<TD width=10 align=\"center\" bgcolor=\"$yearcurdaybgcolor\"><a href=\"".CAL_MODULE_LINK."&m=$m&d=$day&y=$y&op=day\"><FONT color=\"$yearcurdaytxtcolor\" class=\"tiny\">$day</font></a></TD>";
				}
			else {
				echo "\n<TD width=10 align=\"center\" bgcolor=\"$yearbgcolor\"><a href=\"".CAL_MODULE_LINK."&m=$m&d=$day&y=$y&op=day\"><FONT color=$yeartextcolor class=\"tiny\">$day</font></a></TD>";
				}
			if ($day_of_week == 7) {
				$day_of_week = 0;
				echo "\n</TR>";
				}
			$day_of_week += 1;
			}
		/**** Next Greyed month days */
		$day = 1;
		if ($day_of_week != 1) {
			$tmp = 8 - $day_of_week;
			echo "\n<TD colspan=$tmp bgcolor=\"$yearshadedbgcolor\">&nbsp;</TD>";
			}
		echo "\n</TR>\n</TABLE>\n</TD>";
		}
	echo "</TD></TR></TABLE>";
	CloseTable();
	}

#########################################################################################
function calAddTimeRange($startTime,$endTime,$year,$month,$day,$daytextcolor) {
	global $dbi;
	$tmpTime = calGetTime($startTime);
	$tmpTime2 = calGetTime($endTime);
	echo "\n<br><br><FONT COLOR=\"".$daytextcolor."\" class=\"content\">".$tmpTime." - ".$tmpTime2."</FONT>";
	$qry = "SELECT eid, title, hometext, startDate, startTime, endDate, endTime, categorie FROM ".CAL_TABLE_EVENTS." 
	WHERE(startDate<='$year-$month-$day' 
	AND endDate >='$year-$month-$day' 
	AND alldayevent='0' 
	AND startTime >= '$startTime' 
	AND startTime <'$endTime' 
	AND activ=1) 
	ORDER BY startTime, endTime ASC";
	calPrintAppt($qry, $daytextcolor);
	}

#########################################################################################
function calPrintAppt($qry, $daytextcolor) {
	global $dbi, $calconf;
	static $popupwidth, $popupdelay, $cal_overlib;
	if ((!isset($popupwidth) || !isset($popupdelay) || !isset($cal_overlib)) && !calIsPrintView()) {
		include(CAL_MODULE_PATH."config/configcolors.php");
		if ($calconf['ShowPopup']) {
			$cal_overlib = new Overlib();
			$cal_overlib -> ol_width = $popupwidth;
			$cal_overlib -> ol_delay = $popupdelay;
			$cal_overlib -> ol_hauto = "True";
			$cal_overlib -> ol_vauto = "True";
			}
		}
	$out = "";
	$result = sql_query($qry, $dbi);
	while($event = sql_fetch_array($result, $dbi)) {
		$event = calGetEventDates($event);
		$categorie = calGetCurrentEventPoint($event['categorie']);
		$title = calPrepareDisplay(strip_tags($event['title']));
		$popuptext = "";
		if (!calIsPrintView() && $calconf['ShowPopup']) {
			$categoriealt = calGetBarColorAlt($categorie);
			if ($event['startDate'] != $event['endDate']) {
				$poptitle = calValueToText($title."<br><span class=\"tiny\">(".$event['startDateShort']."&nbsp;".$startTime."&nbsp;-&nbsp;".$event['endDateShort']."&nbsp;".$endTime.")</span>");
				}
			else {
				$poptitle = calValueToText($title);
				}
			$poptext = ($event['hometext']) ? calValueToText($categoriealt.":<br>".$event['hometext']."") : calValueToText($categoriealt);
			$cal_overlib -> ol_capicon = "".calGetBarImage("ball", $categorie)."";
			$popuptext = $cal_overlib -> vover($poptext,$poptitle);
			}
		$startTime = calGetTime($event['startTime']);
		$endTime = calGetTime($event['endTime']);
		$view = "<a href=\"".CAL_MODULE_LINK."&op=view&eid=".$event['eid']."\"".$popuptext.">".$startTime;
		$view .= ($event['startDate'] != $event['endDate']) ? "" : "&nbsp;-&nbsp;".$endTime;
		$view .= ", <b>".$title."</b></a>";
		$out .= "<tr valign='top'>
		<td><img src='".calGetBarImage("ball",$categorie)."' alt='' hspace='3' vspace='3' border='0'></td>
		<td><font color=\"".$daytextcolor."\" class=\"content\">".$view."</font></td>
		</tr>";
		}
	if ($out) {
		echo "<table border='0' cellspacing='0' cellpadding='3'>".$out."</table>";
		}
	else {
		echo "<br>";
		}
	}

######################################################################
# wird benoetigt zur Kompatibilitaet mit Original phpNuke
# den benoetigten Code fuer die Klasse overlib nur einmal ausgeben
if (!function_exists("printOverlibDiv")){
	function printOverlibDiv(){
		if (!defined("_Overlib_Div")){
			$folder = (@file_exists("includes/javascript/class.overlib.php")) ? "includes/javascript" : CAL_MODULE_PATH."overlib";
			define("_Overlib_Div",1);
			include_once($folder."/class.overlib.php"); 
			echo "<div id=\"overDiv\" style=\"position:absolute; visibility:hide; z-index: 1000; background: transparent;\"></div>\n";
			echo "<script language=\"javascript\" src=\"".$folder."/overlib.js\">\n</script>\n";
			}
		}
	}

######################################################################
// wandelt die uebergebenen Datumwerte in erforderliche Werte um
// Wird kein gueltiges Datum uebergeben, wird HEUTE verwendet 
// Ausserdem werden bestimmte Defaultwerte gesetzt
function calGetRequestVals($req) {
	global $calconf;
	if (empty($req["op"])) {
		$req["op"] = (isset($req["type"])) ? $req["type"] : $calconf['defaultview'];
		}
	else if ($req["op"]=="modload") {
		$req["op"] = (isset($req["type"])) ? $req["type"] : $calconf['defaultview'];
		}
	if (isset($req["eid"])) $req["eid"] = (int)$req["eid"];
	if (isset($req["d"]))   $req["d"]   = (int)$req["d"];
	if (isset($req["m"]))   $req["m"]   = (int)$req["m"];
	if (isset($req["y"]))   $req["y"]   = (int)$req["y"];
	if (isset($req["col"])) $req["col"] = (int)$req["col"];
	if (empty($req["col"])) $req["col"] = "";
	
	if (empty($req["d"]) || empty($req["m"]) || empty($req["y"])) {
		if (isset($req["Date"])){ # kompatibilitaet mit aelteren Links?
			$arrdate = explode("/", $req["Date"]); # m/d/y
			$req["d"]=(int)$arrdate[1];
			$req["m"]=(int)$arrdate[0];
			$req["y"]=(int)$arrdate[2];
			}
		else { # Heute als Datum
			$req["d"]=(int)Date("d");
			$req["m"]=(int)Date("m");
			$req["y"]=(int)Date("Y");
	  	}
		}
	return $req;
	}

#### main ##########################################################################
$req = array_merge($_GET, $_POST);
$req = array_merge($req, calGetRequestVals($req));
#print_r($req);
$GLOBALS["pagetitle"] = _CALNAME;
if (isset($_GET['cprint'])) {
	include(CAL_MODULE_PATH."includes/printer.php");
	print_header();
	}
else {
	include("header.php");
	}
title(_CALNAME);
if ($req["y"] < 1970){
	OpenTable();
	echo "<center><b>ERROR!</b><br><br>System can not interpret dates before 01/01/1970, <br>If you've used a 2 digit year please use a 4 digit one.<br><br>"._GOBACK."</center>";
	CloseTable();
	}
else {
	#$Date = mktime(0, 0, 0, $m, $d, $y);
	if ($req["op"] == "month") {
		calBuiltMonth($req);
		}
	elseif ($req["op"] == "day") {
		calBuiltDay($req);
		}
	elseif ($req["op"] == "year") {
		calBuiltYear($req);
		}
	elseif ($req["op"] == "view") {
		calViewEvent($req);
		}
	elseif ($req["op"] == "list") {
		calBuiltNextEventsList($req);
		}
	}

if (isset($_GET['cprint'])) {
	print_footer();
	}
else {
	include("footer.php");
	}

/* CVS-Log:
$Log: index.php,v $
Revision 20.12  2004/01/11 10:45:02  EllselAn
sql_freeresult entfernt

Revision 20.11  2004/01/10 16:15:54  EllselAn
sql-injection besser abgesichert

Revision 20.10  2004/01/08 22:43:31  EllselAn
popups umgebaut in druckfunktion und zum abschalten

Revision 20.9  2004/01/07 22:10:22  EllselAn
weitere Pfadanpassungen und Konstanten umgelagert

Revision 20.8  2004/01/06 23:14:59  EllselAn
Pfade angepasst

Revision 20.7  2004/01/05 14:33:46  EllselAn
Copyrighthinweise verndert

Revision 20.6  2004/01/04 00:38:18  EllselAn
versch. Kleinigkeiten

Revision 20.4  2003/11/16 19:19:35  EllselAn
Kalender etwas berarbeitet,
neuer Header, da neuer Name
kleine Fehler gefixt

Revision 20.3  2003/09/12 12:16:11  EllselAn
Javascript-popups etwas berarbeitet

Revision 20.2  2003/09/01 14:50:34  EllselAn
function join() / implode() falsch verwendet


 */

?>