# -*- coding: utf8 -*-
import cPickle,os
import urllib
import re
import shutil
import os
    
class InvalidCityError(Exception): pass # FIXME move to exceptionLib.py
class InvalidIntervalError(Exception): pass # FIXME move to exceptionLib.py

def getCountryInfoList():
    try:
        countryInfoList = eval(file('countries.dat', 'r').read())
    except:
        countryInfoList = []
    return countryInfoList

def getCountryNameList():
    return [name for code, name in getCountryInfoList()]

def getCityList(country):
    cities = []
    defaultCity = ''

    code = countryNameToCode(country)
    try:
        jsonString = urllib.urlopen('http://www.google.com//ig/cities?hl=en&country=%s' % code).read()
    except IOError:
        return cities, defaultCity
   
    cities = re.findall(r'name: "(.+?)"', jsonString, re.UNICODE)

    match = re.search(r'name: "([^{]+?)"[^{]+?selected: (true|false)', jsonString, re.UNICODE)
    if match:
        defaultCity = match.group(1)
    return cities, defaultCity
             
def countryNameToCode(countryName):
    for code, name in getCountryInfoList():
        if name == countryName:
            return code
    return None

defaultCountry = 'Korea' #FIXME
defaultCity = 'Seoul' #FIXME
WEATHERLIST = ['Clear', 'Rain', 'Cloudy', 'Mostly Cloudy', 'Snow', 'Fog', 'Haze', 'Thunderstorm']

class Configuration: 
    def __init__(self):
        if os.path.exists("config.cfg"):
            self.load()
            return
    	self.country = defaultCountry
        self.city = defaultCity
        self.interval = 300
        self.imagesOfWeathers = {}
        self.path = os.getcwd()
        self.wallpaperFolder = os.path.join(self.path, 'wallpapers')
        
    def save(self):
        cPickle.dump(self, file("config.cfg", "w"))
        return True

    def load(self): # FIXME 
        loadedObj = cPickle.load(file("config.cfg", "r"))
	self.__dict__.update(loadedObj.__dict__)

    def setImageOfWeather(self, weather, image):
        self.imagesOfWeathers[weather] = image

    def setCity(self, city):#FIXME
        self.city = city
#        else:
 #           raise InvalidCityError

    def setInterval(self, interval):
        if interval <= 0:
            raise InvalidIntervalError
        self.interval = interval

    def getWeatherList(self):
        return WEATHERLIST


    def copyWallpaper(self, weather, imagePath):
        if not os.path.exists(self.wallpaperFolder):
            os.mkdir(self.wallpaperFolder)
        destPath = os.path.join(self.wallpaperFolder, weather)
        shutil.copy(imagePath, destPath)
        return destPath
