{

   This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}
unit UConfig;

interface

uses
  Windows, Forms, SysUtils, ComCtrls, inifiles, graphics;

type
  TSimpleConfig = class(TObject)
  public
    window_left,window_top,window_width,window_height:integer;
    window_max:boolean;
    effect_max:boolean;
    effect_left,effect_top,effect_width,effect_height:integer;
    ListView1width:integer;
    lastpath:string;
    ratio2,userratio:integer;
    keepratio,enablelastratio:boolean;

    lastvalue_string:string;
    lastvalue_integer:integer;

    c_viewcolor:boolean;
    c_screencapture_hotkey:string;
    c_enablefilehint:boolean;
    c_filehintdelay:integer;
    c_selectmode:boolean;
    c_defaultviewcolor:integer;
    c_enableballoon:boolean;
    c_toolbarshrinkmode:integer;
    c_dialogpreview:boolean;
    c_undomaxcount:integer;
    c_ctrlmovepitch,c_shiftmovepitch:integer;
    c_lastsavefilterindex:integer;
    c_keepselectdraw:boolean;
    c_listthumbsize:integer;

    procedure Initialize;
    procedure LoadFromFile(const FileName: String);
    procedure SaveToFile(const FileName: String);

    procedure setvaluebystring(name,value:string);
    function getvaluebystring(name:string;default:string=''):string;
    procedure setvaluebyinteger(name:string;value:integer);
    function getvaluebyinteger(name:string;default:integer=0):integer;
  end;

var
  Config: TSimpleConfig;

implementation
uses Uregistry, Ufrmmain;

procedure TSimpleConfig.setvaluebystring(name,value:string);
begin
  RegSetString(HKEY_CURRENT_USER,'software\'+thisregname+'\'+name,value);
end;

function TSimpleConfig.getvaluebystring(name:string;default:string=''):string;
begin
  result:=default;
  RegGetString(HKEY_CURRENT_USER,'software\'+thisregname+'\'+name,result);
  lastvalue_string:=result;
end;

procedure TSimpleConfig.setvaluebyinteger(name:string;value:integer);
var
  v:cardinal;
begin
  v:=value;
  RegSetDWORD(HKEY_CURRENT_USER,'software\'+thisregname+'\'+name,v);
end;

function TSimpleConfig.getvaluebyinteger(name:string;default:integer=0):integer;
var
  v:cardinal;
begin
  v:=default;
  RegGetDWORD(HKEY_CURRENT_USER,'software\'+thisregname+'\'+name,v);
  result:=v;
  lastvalue_integer:=result;
end;

procedure TSimpleConfig.Initialize;
begin
  window_left:=10;window_top:=10;window_width:=750;window_height:=450;
  lastpath:='';
end;

procedure TSimpleConfig.LoadFromFile(const FileName: String);
var
  Ini: TInifile;
  i:integer;
begin
  Ini := TInifile.Create(FileName);
  try try
    window_left:=Ini.ReadInteger('Config', 'window_left', window_left);
    window_top:=Ini.ReadInteger('Config', 'window_top', window_top);
    window_width:=Ini.ReadInteger('Config', 'window_width', window_width);
    window_height:=Ini.ReadInteger('Config', 'window_height', window_height);
    window_max:=Ini.ReadBool('Config', 'window_max', false);

    effect_max:=Ini.ReadBool('Config', 'effect_max', false);
    effect_left:=Ini.ReadInteger('Config', 'effect_left', -1);
    effect_top:=Ini.ReadInteger('Config', 'effect_top', -1);
    effect_width:=Ini.ReadInteger('Config', 'effect_width', -1);
    effect_height:=Ini.ReadInteger('Config', 'effect_height', -1);
    window_max:=Ini.ReadBool('Config', 'window_max', false);

    ListView1width:=Ini.ReadInteger('Config', 'ListView1width', 187);
    lastpath:=Ini.ReadString('Config', 'lastpath', lastpath);
    ratio2:=Ini.ReadInteger('Config', 'ratio2', 100);
    userratio:=Ini.ReadInteger('Config', 'userratio', 100);
    keepratio:=Ini.ReadBool('Config', 'keepratio', false);
    enablelastratio:=Ini.ReadBool('Config', 'enablelastratio', true);
    c_viewcolor:=Ini.ReadBool('Config', 'c_viewcolor', true);
    c_screencapture_hotkey:=ini.ReadString('Config', 'c_screencapture_hotkey', 'F11');

    c_enablefilehint:=Ini.ReadBool('Config', 'c_enablefilehint', true);
    c_filehintdelay:=Ini.ReadInteger('Config', 'c_filehintdelay', 350);
    c_selectmode:=Ini.ReadBool('Config', 'c_selectmode', false);
    c_defaultviewcolor:=Ini.ReadInteger('Config', 'c_defaultviewcolor', clAppWorkSpace);
    c_enableballoon:=Ini.ReadBool('Config', 'c_enableballoon', true);
    c_toolbarshrinkmode:=Ini.ReadInteger('Config', 'c_toolbarshrinkmode', 1);
    if c_toolbarshrinkmode>1 then c_toolbarshrinkmode:=1;
    c_dialogpreview:=Ini.ReadBool('Config', 'c_dialogpreview', true);
    c_undomaxcount:=Ini.ReadInteger('Config', 'c_undomaxcount', 50);
    c_ctrlmovepitch:=Ini.ReadInteger('Config', 'c_ctrlmovepitch', 1);
    c_shiftmovepitch:=Ini.ReadInteger('Config', 'c_shiftmovepitch', 5);
    if c_undomaxcount<1 then c_undomaxcount:=50;
    c_lastsavefilterindex:=Ini.ReadInteger('Config', 'c_lastsavefilterindex', 0);
    c_keepselectdraw:=Ini.ReadBool('Config', 'c_keepselectdraw', true);
    c_listthumbsize:=Ini.ReadInteger('Config', 'c_listthumbsize', 80);
    if (c_listthumbsize<30) or (c_listthumbsize>150) then c_listthumbsize:=80;
  except
  end;
  finally
    Ini.Free;
  end;
end;

procedure TSimpleConfig.SaveToFile(const FileName: String);
var
  Ini: TInifile;
  i:integer;
begin
  ForceDirectories(ExtractFilePath(FileName));
  Ini := TInifile.Create(FileName);
  try try
    Ini.WriteInteger('Config', 'window_left', window_left);
    Ini.WriteInteger('Config', 'window_top', window_top);
    Ini.WriteInteger('Config', 'window_width', window_width);
    Ini.WriteInteger('Config', 'window_height', window_height);

    Ini.WriteBool('Config', 'effect_max', effect_max);
    Ini.WriteInteger('Config', 'effect_left', effect_left);
    Ini.WriteInteger('Config', 'effect_top', effect_top);
    Ini.WriteInteger('Config', 'effect_width', effect_width);
    Ini.WriteInteger('Config', 'effect_height', effect_height);

    Ini.WriteBool('Config', 'window_max', window_max);
    Ini.WriteInteger('Config', 'ListView1width', ListView1width);
    Ini.WriteString('Config', 'lastpath', lastpath);
    Ini.WriteInteger('Config', 'ratio2', ratio2);
    Ini.WriteInteger('Config', 'userratio', userratio);
    Ini.WriteBool('Config', 'keepratio', keepratio);
    Ini.WriteBool('Config', 'enablelastratio', enablelastratio);
    Ini.WriteBool('Config', 'c_viewcolor', c_viewcolor);
    ini.WriteString('Config', 'c_screencapture_hotkey', c_screencapture_hotkey);

    Ini.WriteBool('Config', 'c_enablefilehint', c_enablefilehint);
    Ini.WriteInteger('Config', 'c_filehintdelay', c_filehintdelay);
    Ini.WriteBool('Config', 'c_selectmode', c_selectmode);
    Ini.WriteInteger('Config', 'c_defaultviewcolor', c_defaultviewcolor);
    Ini.WriteBool('Config', 'c_enableballoon', c_enableballoon);
    Ini.WriteInteger('Config', 'c_toolbarshrinkmode', c_toolbarshrinkmode);
    Ini.WriteBool('Config', 'c_dialogpreview', c_dialogpreview);
    Ini.WriteInteger('Config', 'c_undomaxcount', c_undomaxcount);
    Ini.WriteInteger('Config', 'c_ctrlmovepitch', c_ctrlmovepitch);
    Ini.WriteInteger('Config', 'c_shiftmovepitch', c_shiftmovepitch);
    Ini.WriteInteger('Config', 'c_lastsavefilterindex', c_lastsavefilterindex);
    Ini.WriteBool('Config', 'c_keepselectdraw', c_keepselectdraw);
    Ini.WriteInteger('Config', 'c_listthumbsize', c_listthumbsize);
  except
  end;
  finally
    Ini.Free;
  end;
end;

initialization
  Config := TSimpleConfig.Create;
  Config.Initialize;

finalization
  Config.Free;

end.

