unit Ufrmmain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Umain_hlp, ComCtrls, ExtCtrls, Buttons, Menus, ImgList;

const
  thisregname = 'nSeries\nView\libupload';

type
  Tfrmmain = class(TForm)
    MainMenu1: TMainMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    ImageList1: TImageList;
    N5: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    SaveDialog1: TSaveDialog;
    N8: TMenuItem;
    N9: TMenuItem;
    N12: TMenuItem;
    N13: TMenuItem;
    Panel2: TPanel;
    PageControl1: TPageControl;
    TabSheet1: TTabSheet;
    Memo1: TMemo;
    TabSheet6: TTabSheet;
    Memo6: TMemo;
    TabSheet2: TTabSheet;
    Memo2: TMemo;
    TabSheet3: TTabSheet;
    Memo3: TMemo;
    TabSheet7: TTabSheet;
    Memo7: TMemo;
    TabSheet4: TTabSheet;
    Memo4: TMemo;
    TabSheet5: TTabSheet;
    Memo5: TMemo;
    Panel3: TPanel;
    files: TMemo;
    Panel1: TPanel;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    ProgressBar1: TProgressBar;
    ProgressBar2: TProgressBar;
    Panel4: TPanel;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    Label5: TLabel;
    Splitter1: TSplitter;
    CheckBox1: TCheckBox;
    ComboBox1: TComboBox;
    procedure FormCreate(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure N6Click(Sender: TObject);
    procedure N7Click(Sender: TObject);
    procedure N4Click(Sender: TObject);
    procedure N1Click(Sender: TObject);
    procedure N8Click(Sender: TObject);
    procedure N12Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
  private
    { Private declarations }
    tempfolder:string;
    procedure WndProc(var Message: TMessage); override;
  public
    strlist:tstringlist;  
    { Public declarations }
  end;

  Tupload = class(TThread)
  private
    imageshack:Timageshack;
    Fstop:boolean;
    procedure imageshackuploadcallback2(calldata:Pcalldata);
  protected
    procedure Execute; override;
  public
    files:tstringlist;
    formhandle:thandle;
    optsize:string;
    constructor CreateThread;
    destructor Destroy; override;
    procedure stop;
  end;

var
  frmmain: Tfrmmain;
  upload: Tupload;

implementation
uses Ufunction, Uregistry, shlobj, shellapi;
{$R *.dfm}

procedure setvaluebystring(name,value:string);
begin
  RegSetString(HKEY_CURRENT_USER,'software\'+thisregname+'\'+name,value);
end;

function getvaluebystring(name:string;default:string=''):string;
begin
  result:=default;
  RegGetString(HKEY_CURRENT_USER,'software\'+thisregname+'\'+name,result);
end;

procedure setvaluebyinteger(name:string;value:integer);
var
  v:cardinal;
begin
  v:=value;
  RegSetDWORD(HKEY_CURRENT_USER,'software\'+thisregname+'\'+name,v);
end;

function getvaluebyinteger(name:string;default:integer=0):integer;
var
  v:cardinal;
begin
  v:=default;
  RegGetDWORD(HKEY_CURRENT_USER,'software\'+thisregname+'\'+name,v);
  result:=v;
end;


procedure imageshackuploadcallback(calldata:Pcalldata); cdecl;
begin
  upload.imageshackuploadcallback2(calldata);
end;

{Tupload}
constructor Tupload.CreateThread;
begin
  inherited Create(true);
  FreeOnTerminate:=false;
  imageshack:=Timageshack.Create;
end;

destructor Tupload.Destroy;
begin
  imageshack.Free;
  inherited Destroy;
end;

procedure Tupload.Execute;
var
  i,j:integer;
  calldata:Pcalldata;
begin
  Fstop:=false;
  try
    for i:=0 to files.Count-1 do begin
      if self.Terminated then break;
      if Fstop then break;
      for j:=1 to 2 do begin
       if self.Terminated then break;
       if Fstop then break;
       new(calldata);
       try
        calldata.idx:=i;
        calldata.total:=files.Count;
        strpcopy(calldata.filename,files.Strings[i]);
        strpcopy(calldata.optsize,optsize);
        calldata.rembar:=getvaluebyinteger('thumbremovebar',0)=1;
        calldata.size:=0;
        calldata.uploaded:=0;
        calldata.speed:=0;
        calldata.userabort:=false;
        calldata.errmsg:='';
        calldata.state:=usready;
        calldata.result_width:='';
        calldata.result_height:='';
        calldata.result_image_link:='';
        calldata.result_image_html:='';
        calldata.result_thumb_link:='';
        calldata.result_thumb_html:='';
        calldata.result_ad_link:='';

        imageshack.calldata:=calldata;
        imageshack.uploadcallback:=imageshackuploadcallback;
        imageshack.upload;
        if (j=1) and (calldata.state=ushttperror) then begin
          continue;
        end;
        sendmessage(formhandle, wm_user+1002, integer(calldata), 0);
       finally
         dispose(calldata);
       end;
       break;
      end;
      sleep(100);
    end;
  except
  end;
  sendmessage(formhandle, wm_user+1003, 0, 0);
end;

procedure Tupload.imageshackuploadcallback2(calldata:Pcalldata);
begin
  if Fstop then calldata.userabort:=true;
  sendmessage(formhandle, wm_user+1001, integer(calldata), 0);
end;

procedure Tupload.stop;
begin
  Fstop:=true;
  imageshack.stop;
  self.Terminate;
end;

procedure Tfrmmain.WndProc(var Message: TMessage);
var
  calldata:Pcalldata;
  s:string;
begin
  with Message do
    case Msg of
      wm_user+1001:begin
        calldata:=Pcalldata(wparam);
        ProgressBar2.Max:=calldata.total;
        ProgressBar2.Position:=calldata.idx+1;
        label2.Caption:=format('%d/%d',[calldata.idx+1,calldata.total]);
        ProgressBar1.Max:=calldata.size;
        ProgressBar1.Position:=calldata.uploaded;
        label1.Caption:=format('%s/%s byte',[FormatFloat('#,###,###',calldata.uploaded),FormatFloat('#,###,###',calldata.size)]);
        label3.Caption:=ExtractFileName(calldata.filename);
      end;
      wm_user+1002:begin
        calldata:=Pcalldata(wparam);
        if calldata.state=ussuccess then begin
          s:=ExtractFileName(calldata.filename);
          memo1.Lines.Add(format('%s, %s',[s,calldata.result_image_link]));
          memo2.Lines.Add(format('%s, %s',[s,calldata.result_image_html]));
          memo3.Lines.Add(format('%s, %s',[s,calldata.result_thumb_link]));
          memo4.Lines.Add(format('%s, %s',[s,calldata.result_thumb_html]));
          memo5.Lines.Add(format('%s, %s',[s,calldata.result_ad_link]));
          memo6.Lines.Add(format('%s<br><img src="%s"><br><br>',[s,calldata.result_image_link]));
          memo7.Lines.Add(format('%s<br><img src="%s"><br><br>',[s,calldata.result_thumb_link]));
        end else begin
          s:=format('%s, : %s',[ExtractFileName(calldata.filename), calldata.errmsg]);
          memo1.Lines.Add(s);
          memo2.Lines.Add(s);
          memo3.Lines.Add(s);
          memo4.Lines.Add(s);
          memo5.Lines.Add(s);
          memo6.Lines.Add(s+'<br>');
          memo7.Lines.Add(s+'<br>');
        end;
      end;
      wm_user+1003:begin
        BitBtn1.Enabled:=true;
        BitBtn2.Enabled:=false;
//        label3.Caption:=' ϷϿϴ.';
        _messagedlg(self,' ϷϿϴ.',mtinformation, mbOk);
      end;
    end;
  inherited;
end;

procedure Tfrmmain.FormCreate(Sender: TObject);
 procedure load_lastlinks(memo:tmemo;s:string);
 begin
   if sysutils.FileExists(s) then
     memo.Lines.LoadFromFile(s);
 end;
begin
//  strlist:=tstringlist.Create;
  self.Width:=790;
  self.Height:=520;

  panel2.Align:=alclient;
  PageControl1.ActivePageIndex:=0;
  label1.Caption:='';
  label2.Caption:='';
  label3.Caption:='';

  tempfolder:=GetSpecialFolder(CSIDL_APPDATA)+'nSeries\nView\temp\libupload\';
  sysutils.ForceDirectories(tempfolder);

  load_lastlinks(memo1,tempfolder+'lastlinks1.txt');
  load_lastlinks(memo2,tempfolder+'lastlinks2.txt');
  load_lastlinks(memo3,tempfolder+'lastlinks3.txt');
  load_lastlinks(memo4,tempfolder+'lastlinks4.txt');
  load_lastlinks(memo5,tempfolder+'lastlinks5.txt');
  load_lastlinks(memo6,tempfolder+'lastlinks6.txt');
  load_lastlinks(memo7,tempfolder+'lastlinks7.txt');

//  files.Width:=getvaluebyinteger('fileswidth',160);
  CheckBox1.Checked:=getvaluebyinteger('thumbremovebar',0)=1;
  ComboBox1.ItemIndex:=getvaluebyinteger('optsize',0);
end;

procedure Tfrmmain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  setvaluebyinteger('fileswidth',files.Width);
  setvaluebyinteger('optsize',ComboBox1.ItemIndex);
  if getvaluebyinteger('lastlinksave',1)=1 then begin
    memo1.Lines.SaveToFile(tempfolder+'lastlinks1.txt');
    memo2.Lines.SaveToFile(tempfolder+'lastlinks2.txt');
    memo3.Lines.SaveToFile(tempfolder+'lastlinks3.txt');
    memo4.Lines.SaveToFile(tempfolder+'lastlinks4.txt');
    memo5.Lines.SaveToFile(tempfolder+'lastlinks5.txt');
    memo6.Lines.SaveToFile(tempfolder+'lastlinks6.txt');
    memo7.Lines.SaveToFile(tempfolder+'lastlinks7.txt');
  end else begin
    deletefile(tempfolder+'lastlinks1.txt');
    deletefile(tempfolder+'lastlinks2.txt');
    deletefile(tempfolder+'lastlinks3.txt');
    deletefile(tempfolder+'lastlinks4.txt');
    deletefile(tempfolder+'lastlinks5.txt');
    deletefile(tempfolder+'lastlinks6.txt');
    deletefile(tempfolder+'lastlinks7.txt');
  end;

  if upload<>nil then begin
    upload.stop;
    upload.WaitFor;
    upload.Free;
    upload:=nil;
  end;

  deletefile(tempfolder+'uploadthumbtag.html');
  deletefile(tempfolder+'uploadimagetag.html');
end;

procedure Tfrmmain.BitBtn1Click(Sender: TObject);
var
  i:integer;
begin
  if strlist.Count=0 then begin
    _messagedlg(self,'ε  ̹ ϴ.',mterror, mbOk);
    exit;
  end;
  if _messagedlg(self,format('%d ̹ ε Ͻðڽϱ?',[strlist.Count]),
      mtConfirmation, mbYes)<>mrYes then
    exit;

  if upload<>nil then begin
    upload.stop;
    upload.WaitFor;
    upload.Free;
    upload:=nil;
  end;
  BitBtn1.Enabled:=false;
  BitBtn2.Enabled:=true;

  for i:=0 to self.PageControl1.PageCount-1 do begin
   if (PageControl1.Pages[i].Controls[0] as tmemo).Lines.Count>0 then
     (PageControl1.Pages[i].Controls[0] as tmemo).Lines.Add('');
  end;
  upload:=Tupload.CreateThread;
  upload.formhandle:=handle;
  upload.files:=strlist;
  case self.ComboBox1.ItemIndex of
    0:upload.optsize:='';
    1:upload.optsize:='100x100';
    2:upload.optsize:='150x150';
    3:upload.optsize:='320x320';
    4:upload.optsize:='640x640';
    5:upload.optsize:='800x800';
    6:upload.optsize:='1024x1024';
    7:upload.optsize:='1280x1280';
    8:upload.optsize:='1600x1600';
    9:upload.optsize:='optimize';
    else
      upload.optsize:='';
  end;
  upload.Resume;
end;

procedure Tfrmmain.BitBtn2Click(Sender: TObject);
begin
  if upload<>nil then
    upload.stop;
end;

procedure Tfrmmain.N2Click(Sender: TObject);
begin
  if _messagedlg(self,' ðڽϱ?', mtConfirmation, mbYes)<>mrYes then
    exit;
  memo1.Clear;
  memo2.Clear;
  memo3.Clear;
  memo4.Clear;
  memo5.Clear;
  memo6.Clear;
  memo7.Clear;
end;

procedure Tfrmmain.N3Click(Sender: TObject);
var
  s:string;
begin
  s:=tempfolder+'uploadimagetag.html';
  memo6.Lines.SaveToFile(s);
  ShellExecute(0, 'open', pchar(s), nil, nil, SW_SHOW);
end;

procedure Tfrmmain.N6Click(Sender: TObject);
var
  s:string;
begin
  if SaveDialog1.Execute=false then exit;
  s:=SaveDialog1.FileName;
  s:=sysutils.ChangeFileExt(s,'.txt');
  (PageControl1.ActivePage.Controls[0] as tmemo).Lines.SaveToFile(s);
end;

procedure Tfrmmain.N7Click(Sender: TObject);
var
  strlist:tstringlist;
  i:integer;
  s:string;
begin
  if SaveDialog1.Execute=false then exit;
  strlist:=tstringlist.Create;
  try
    for i:=0 to self.PageControl1.PageCount-1 do begin
      strlist.Add('==============================');
      strlist.Add(PageControl1.Pages[i].Caption);
      strlist.Add('==============================');
      s:=(PageControl1.Pages[i].Controls[0] as tmemo).Lines.Text;
      strlist.Add(s);
      strlist.Add('');
    end;
    s:=SaveDialog1.FileName;
    s:=sysutils.ChangeFileExt(s,'.txt');
    strlist.SaveToFile(s);
  finally
    strlist.Free;
  end;
end;

procedure Tfrmmain.N4Click(Sender: TObject);
var
  s:string;
begin
  s:=tempfolder+'uploadthumbtag.html';
  memo7.Lines.SaveToFile(s);
  ShellExecute(0, 'open', pchar(s), nil, nil, SW_SHOW);
end;

procedure Tfrmmain.N1Click(Sender: TObject);
begin
  n8.Checked:=getvaluebyinteger('lastlinksave',1)=1;
end;

procedure Tfrmmain.N8Click(Sender: TObject);
begin
  n8.Checked:=not n8.Checked;
  setvaluebyinteger('lastlinksave',integer(n8.Checked));
end;

procedure Tfrmmain.N12Click(Sender: TObject);
begin
  if _messagedlg(self,format('"%s"  ðڽϱ?',[PageControl1.ActivePage.Caption]),
      mtConfirmation, mbYes)<>mrYes then
    exit;
  (self.PageControl1.ActivePage.Controls[0] as tmemo).Clear;
end;

procedure Tfrmmain.FormShow(Sender: TObject);
var
  i:integer;
begin
  label5.Caption:=format('%d ̹ ε',[strlist.Count]);
  for i:=0 to strlist.Count-1 do begin
    files.Lines.Add(ExtractFileName(strlist.Strings[i]));
  end;
end;

procedure Tfrmmain.CheckBox1Click(Sender: TObject);
begin
  setvaluebyinteger('thumbremovebar',integer(CheckBox1.Checked));
end;

end.

