unit UnViewColorBox;

interface
uses windows, classes, ExtCtrls, graphics, ColorDialogAdv, forms;

type
  TnViewColorBox = class(TCustomColorBox)
  protected
    function PickCustomColor: Boolean; override;
    procedure CreateWnd; override;
  public
    constructor Create(AOwner: TComponent); override;
    procedure Loaded; override;
  published
    property AutoComplete;
    property AutoDropDown;
    property DefaultColorColor;
    property NoneColorColor;
    property Selected;
    property Style;

    property Anchors;
    property BevelEdges;
    property BevelInner;
    property BevelKind;
    property BevelOuter;
    property BiDiMode;
    property Color;
    property Constraints;
    property Ctl3D;
    property DropDownCount;
    property Enabled;
    property Font;
    property ItemHeight;
    property ParentBiDiMode;
    property ParentColor;
    property ParentCtl3D;
    property ParentFont;
    property ParentShowHint;
    property PopupMenu;
    property ShowHint;
    property TabOrder;
    property TabStop;
    property Visible;
    property OnChange;
    property OnCloseUp;
    property OnClick;
    property OnContextPopup;
    property OnDblClick;
    property OnDragDrop;
    property OnDragOver;
    property OnDropDown;
    property OnEndDock;
    property OnEndDrag;
    property OnEnter;
    property OnExit;
    property OnKeyDown;
    property OnKeyPress;
    property OnKeyUp;
    property OnSelect;
    property OnStartDock;
    property OnStartDrag;
  end;

  procedure Register;

var
  gColorDialogAdv:TColorDialogAdv;

implementation

procedure Register;
begin
  RegisterComponents('nSeries', [TnViewColorBox]);
end;

{TnViewColorBox}
constructor TnViewColorBox.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
end;

procedure TnViewColorBox.CreateWnd;
begin
  inherited CreateWnd;
end;

procedure TnViewColorBox.Loaded;
begin
  inherited;
  if (cbCustomColor in Style) then
    if Items.Count>0 then
      Items.Strings[0]:='';
end;

function TnViewColorBox.PickCustomColor: Boolean;
var
  LColor: TColor;
  pt:tpoint;
begin
  if gColorDialogAdv=nil then
    gColorDialogAdv:=TColorDialogAdv.Create(nil);

  pt:=self.ClientToScreen(point(0,0));
  with gColorDialogAdv do begin
    TheForm.Left:=pt.X;
    if TheForm.Left<0 then TheForm.Left:=0;
    if TheForm.Left+TheForm.Width>screen.WorkAreaWidth then TheForm.Left:=screen.WorkAreaWidth-TheForm.Width;
    TheForm.Top:=pt.Y+self.Height+3;
    if TheForm.Top<0 then TheForm.Top:=0;
    if TheForm.Top+TheForm.Height>screen.WorkAreaHeight then TheForm.Top:=screen.WorkAreaHeight-TheForm.Height;
    TheForm.Caption:='';
  end;

  LColor := ColorToRGB(TColor(Items.Objects[0]));
  gColorDialogAdv.Color:=Lcolor;
  Result:=gColorDialogAdv.Execute;
  if Result then begin
    Items.Objects[0] := TObject(gColorDialogAdv.Color);
    Self.Invalidate;
  end;
end;

initialization

finalization
  if assigned(gColorDialogAdv) then gColorDialogAdv.Free;

end.
