package net.kldp.j2ee.kupload;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;

public class FieldValue {

	private int end;
	private int start;
	private ByteBuffer buffer;
	private String encoding;

	public FieldValue(ByteBuffer buffer, int start, int end, String encoding) {
		this.buffer = buffer;
		this.start = start;
		this.end = end;
		this.encoding = encoding;
	}

	@Override
	public String toString() {
		int length = end - start + 1;
		byte[] b = new byte[length];
		buffer.position(start);
		buffer.get(b, 0, length);
		try {
			return new String(b, encoding);
		} catch (UnsupportedEncodingException e) {
		}
		return null;
	}
}