package net.kldp.j2ee.kupload;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

/**
 * MultiPart 파싱을 위한 클래스
 */
final class DataSection {
	StringBuilder boundary = new StringBuilder();
	int position = 0;
	int start = 0;
	int end = 0;
	final int length;
	private MappedByteStream stream;
	
	public DataSection(InputStream in, int length, int memSize) throws IOException, HttpServletUploadException {
		this.length = length;
		if (length < memSize)
			this.stream = new MemoryMappedByteStream(in, length);
		else
			this.stream = new DiskMappedByteStream(in, length);
	}
	
	public byte getPosition(int position) {
		return stream.getPosition(position);
	}

	public ByteBuffer getBuffer() {
		return stream.getBuffer();
	}
}