package net.kldp.j2ee.kupload;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class ByteData {
	private static final int SIZE = 8192;
	private byte[] bytes = new byte[SIZE];
	private int position;
	private static final String encoding = "UTF-8";

	public void add(byte b) {
		if (position >= bytes.length)
			bytes = Arrays.copyOf(bytes, SIZE + bytes.length);
		bytes[position] = b;
		position++;
	}

	@Override
	public String toString() {
		return toString(encoding);
	}

	public String toString(String encoding) {
		try {
			new String(bytes, 0, position, encoding);
		} catch (UnsupportedEncodingException e) {
		}
		return null;
	}
}