/// @file TimeController.h
#ifndef TIMECONTROLLER_H
#define TIMECONTROLLER_H
#include <time.h>
/**
	@brief ð帧  Ŭ ȯ ü

	applyCycleFloor Լ  ü
*/
struct CycleFloor {
	CycleFloor() : cycle(0), dt(0), step(0), rt(0) {}
	//entry data
	int cycle;
	float dt;
	//excution data
	int step;
	float rt;
};
/**
	@brief ð μ   ü
	
	applyElpasedTime Լ  ü
*/
struct TimePocket {
	TimePocket() : dt(0), rt(0) {}
	float dt;
	float rt;
};
/**
	@brief ð μ  Ŭ

	 ð帧 ϴ ŬԴϴ.
	帥ð üũϴ excuteTimeController Լ Ÿ ƿԼ Ǿ ֽϴ.
	ControlTable ԵǸ,  ControlTable ٰ 簴ü TimeController   ֽϴ.
*/
class TimeController {
public:
	TimeController(){
		fElpasedTime_ = 0;
		dStartTime_   = dLastTime_ = timeGetTime();
		dFrameCount_  = 0;
	}
	~TimeController(){
	}
	void excuteTimeController(){
		dCurTime_     = timeGetTime();
		fElpasedTime_ = (float)((dCurTime_ - dLastTime_) * 0.001);
		dLastTime_    = dCurTime_;
		dFrameCount_++;
	}
	void applyCycleFloor(CycleFloor& _cycleFloor){
		_cycleFloor.rt += fElpasedTime_;
		if( _cycleFloor.rt > _cycleFloor.dt ){
			_cycleFloor.step++;
			if( _cycleFloor.step > _cycleFloor.cycle ){_cycleFloor.step = 0;}
			_cycleFloor.rt = 0.0f;
		}
	}
	void applyElpasedTime(float& _time){
		_time += fElpasedTime_;
	}
	void showFPS(LPD3DXFONT _pFont, const int _l, const int _r, const int _t, const int _b){
		aFpsFontPosition_.left   = _l;
		aFpsFontPosition_.right  = _r;
		aFpsFontPosition_.top    = _t;
		aFpsFontPosition_.bottom = _b;
		frameRate_ = (float) dFrameCount_ / ((dCurTime_ - dStartTime_) * 0.001f);
		sprintf(strFPS_, "%.2f FPS",frameRate_);
		_pFont->DrawText(NULL,strFPS_,-1,&aFpsFontPosition_,DT_CENTER,0xffffffff);
	}
	void setFPS(const int _frameRate){
		while(frameRate_ > _frameRate){
			Sleep(1);
			frameRate_ = (float) dFrameCount_ / ((timeGetTime() - dStartTime_) * 0.001f);
		}
	}
private:
	float  fElpasedTime_;
	double dCurTime_;
	double dLastTime_;
	double dStartTime_;
	DWORD  dFrameCount_;
	float  frameRate_;
	char   strFPS_[20];
	RECT   aFpsFontPosition_;
};
#endif