/// @file TestFade.h
#ifndef TESTFADE_H
#define TESTFADE_H

#include "../core/process/Actor.h"

/**
	@brief Test Actor

	 ׽Ʈ  ü
*/
class TestFade : public Actor {
	public:
		TestFade(){}
		virtual ~TestFade(){}
		static Actor* makeTestFade(TiXmlElement* _pTestFadeElement){
			TestFade* pTestFade = new TestFade;
			int l, r, t, b;
			_pTestFadeElement->Attribute("l", &l);
			_pTestFadeElement->Attribute("r", &r);
			_pTestFadeElement->Attribute("t", &t);
			_pTestFadeElement->Attribute("b", &b);

			pTestFade->aRect_.left = l;
			pTestFade->aRect_.right = r;
			pTestFade->aRect_.top = t;
			pTestFade->aRect_.bottom = b;
			
			pTestFade->fX = -((float(r-l))/2);
			pTestFade->fY = (float(b-t))/2;

			return (Actor*)pTestFade;
		}
		void process(){
			//Todo :  esc, ٷ ε
		}
		void setRObject(DevicePocket* _pDevicePocket, ControlTable* _pControlTable){
			pD3DDevice_ = _pDevicePocket->aCoreGraphic.getD3DDevice();
			pSprite_ = _pDevicePocket->aCoreGraphic.getSprite();

			pCoreInput_ = &(_pDevicePocket->aCoreInput);
			pControlTable = _pControlTable;

			D3DXMATRIXA16 matTrans, matScale, matRotZ;
			D3DXMatrixRotationZ(&matRotZ, D3DX_PI);
			D3DXMatrixScaling(&matScale, 0.55f, 0.55f, 1.0f);
			D3DXMatrixTranslation(&matTrans, fX, -fY, 10.0f);
			//ǥ ݴ
			matWorld = matTrans * matScale * matRotZ;

			aCycleFloor_.cycle = 1;
			aCycleFloor_.dt = 2;
		}
		void draw(Model* _pModel){
			static float time1 = 0;
			static float time3 = 0;
			float a;
			if(aCycleFloor_.step == 0 ){
				//۽ÿ ̵- ȿ ݴ
				//pControlTable_->aTimeController.applyElpasedTime(time1);
				//a = time1 / 2.0f
				//if(a > 0.99){a = 1;}
				a = 1;
				pControlTable->aTimeController.applyCycleFloor(aCycleFloor_);
			}else if(aCycleFloor_.step == 1){
				pControlTable->aTimeController.applyElpasedTime(time3);
				a = 1 - (time3)/2.0f;
				//a = 1 - pControlTable_->aTimeController.getProgressRate(2, time3);
				if(a < 0.01){
					a = 0;
					aCycleFloor_.step = 0;
				}
			}

			pD3DDevice_->SetTransform( D3DTS_WORLD, &matWorld);
			pSprite_->Draw(_pModel->pTexture, &aRect_, NULL, NULL, D3DCOLOR_COLORVALUE(1.0f,1.0f,1.0f,a));
			if( aCycleFloor_.step == 2){
				//pControlTable_->runMode = CONTROL_TRANS;
				//ȿ ,  εض ش.

				//test, ׳ ̵ -ƿ  
				time1 = 0;
				aCycleFloor_.rt = 0;
				aCycleFloor_.step = 0;
				time3 = 0;
			}
		}
	private:
		int state_;
		RECT          aRect_;

		LPDIRECT3DDEVICE9     pD3DDevice_;
		LPD3DXSPRITE          pSprite_;

		CoreInput* pCoreInput_;
		CycleFloor aCycleFloor_;
};
#endif