/// @file PrintBoard.h
#ifndef PRINTBOARD_H
#define PRINTBOARD_H

#include "../core/process/Actor.h"
#include <string>
#include <vector>
using std::string;
using std::vector;

/**
	@brief   ü

	script print command ȭ鿡 ڸ   ִ üԴϴ.\n
	ŰԷ     ֽϴ.
*/
class PrintBoard : public Actor {
public:
	static void cmdPrint(Actor* _pRObject){
		string strContent;
		const char* pStr;
		TiXmlElement* pPrintElement;

		PrintBoard* pPrintBoard = (PrintBoard*)(_pRObject);
		pPrintElement = pPrintBoard->pControlTable->pCommandElement->FirstChildElement("print");
		int line = 1;
		while(pPrintElement){
			if(pStr = pPrintElement->GetText()){
				strContent = pStr;
			}else{
				strContent = "";
			}
			pPrintBoard->aStringPocket.push_back(strContent);
			if(pPrintElement->FirstChildElement("wait")){
				pPrintBoard->aWaitPoint.push_back(line);
				pPrintBoard->setWait();
				pPrintBoard->pControlTable->runMode = ControlTable::PROCESS;
			}
			pPrintElement = pPrintElement->NextSiblingElement("print");
			line++;
		}
		pPrintBoard->aWaitPoint.push_back(line);
	}
public:
	PrintBoard() :
		aColor_(D3DCOLOR_COLORVALUE(1.0f,1.0f,1.0f,0.5f)),wpIndex_(0), bCKeyState_(FALSE){}
	virtual ~PrintBoard(){}
	static Actor* makePrintBoard(TiXmlElement* _pPrintBoardElement){
		PrintBoard* pPrintBoard = new PrintBoard;
		int x, y, l, r, t, b;
		_pPrintBoardElement->Attribute("x", &x);
		_pPrintBoardElement->Attribute("y", &y);
		_pPrintBoardElement->Attribute("l", &l);
		_pPrintBoardElement->Attribute("r", &r);
		_pPrintBoardElement->Attribute("t", &t);
		_pPrintBoardElement->Attribute("b", &b);

		pPrintBoard->aRect_.left = l;
		pPrintBoard->aFontRect_.left = l+15;
		pPrintBoard->aRect_.right = r;
		pPrintBoard->aFontRect_.right = r-15;
		pPrintBoard->aRect_.top = t;
		pPrintBoard->aFontRect_.top = t+20;
		pPrintBoard->aRect_.bottom = b;
		pPrintBoard->aFontRect_.bottom = b-20;
		
		pPrintBoard->fX = x - (float(r-l))/2;
		pPrintBoard->fY = y + (float(b-t))/2;

		return (Actor*)pPrintBoard;
	}
	void process(){
		if(bFocus){
			if(pCoreInput_->clickedKey(DIK_C, bCKeyState_)){
				if(wpIndex_ < wpNum_){
					wpIndex_ ++;
				}else if(wpIndex_ == wpNum_){
					pControlTable->runMode = ControlTable::SCRIPT;
					bFocus = false;
				}
			}
		}
	}
	void setRObject(DevicePocket* _pDevicePocket, ControlTable* _pControlTable){
		pD3DDevice_ = _pDevicePocket->aCoreGraphic.getD3DDevice();
		pSprite_ = _pDevicePocket->aCoreGraphic.getSprite();
		pFont_ = _pDevicePocket->aCoreGraphic.getFont(0);

		pCoreInput_ = &(_pDevicePocket->aCoreInput);
		pControlTable = _pControlTable;

		D3DXMATRIXA16 matTrans, matScale, matRotZ;
		D3DXMatrixRotationZ(&matRotZ, D3DX_PI);
		D3DXMatrixScaling(&matScale, 1.0f, 1.0f, 1.0f);
		D3DXMatrixTranslation(&matTrans, fX, -fY, 10.0f);
		//ǥ ݴ
		matWorld = matTrans * matScale * matRotZ;
	}
	void draw(Model* _pModel){
		if(bShow){
			//pD3DDevice_->SetTransform( D3DTS_WORLD, &matWorld_);
			pSprite_->SetTransform(&matWorld);
			pSprite_->Draw(_pModel->pTexture, &aRect_, NULL, NULL, aColor_);
			RECT aTempFontRect = {aFontRect_.left, aFontRect_.top, aFontRect_.right, aFontRect_.bottom};
			int line = 0;
			if(aWaitPoint.empty()){
				for(pStringItr_ = aStringPocket.begin();pStringItr_ != aStringPocket.end(); pStringItr_++){
					pFont_->DrawText(pSprite_,pStringItr_->c_str(),-1,&aTempFontRect,DT_NOCLIP,0xffffffff);
					aTempFontRect.top += 18;
				}
			}else{
				for(pStringItr_ = aStringPocket.begin();
					pStringItr_ != aStringPocket.end()  && line < aWaitPoint[wpIndex_]; pStringItr_++, line++){
					pFont_->DrawText(pSprite_,pStringItr_->c_str(),-1,&aTempFontRect,DT_NOCLIP,0xffffffff);
					//pFont_->DrawText(pSprite_,pStringItr_->c_str(),-1,&aTempFontRect,DT_NOCLIP,D3DCOLOR_COLORVALUE(1.0f,1.0f,1.0f,0.8f));
					aTempFontRect.top += 18;
				}
			}
		}
	}
	void setWait(){
		bFocus = TRUE;
		wpNum_ = aWaitPoint.size();
	}
	vector<string> aStringPocket;
	vector<int>    aWaitPoint;
private:
	int wpIndex_;
	int wpNum_;
	bool bCKeyState_;
	D3DCOLOR      aColor_;
	RECT          aRect_;
	RECT          aFontRect_;

	LPDIRECT3DDEVICE9     pD3DDevice_;
	LPD3DXSPRITE          pSprite_;
	LPD3DXFONT            pFont_;

	CoreInput* pCoreInput_;
	vector<string>::iterator pStringItr_;
};
#endif