#include "GameCore.h"

void GameCore::initGame(HWND _hWnd, int _width, int _height, bool _bWindowed){
	
	//init Game Device in ActionManager(especially DevicePocket)
	aActionManager_.aDevicePocket.aCoreGraphic.initD3D(_hWnd, _width, _height, _bWindowed);
	aActionManager_.aDevicePocket.aCoreInput.initDInput(_hWnd);
	aActionManager_.aDevicePocket.aCoreSound.InitDirectSound(_hWnd);

	//init ControlTable in GameCore
	pControlTable_ = &(aActionManager_.aControlTable);

	//init Core Manager
	aRenderManager_.initRenderPocket(&aActionManager_.aDevicePocket.aCoreGraphic, pControlTable_);
	aScriptManager_.initManager(&aActionManager_, &aRenderManager_);
	
	//Game ó ۵ɶ εǾ  ͵
	aScriptManager_.loadXmlFile_("logo.xml");
	
	//test Sound : need refactoring when M8
	aActionManager_.aDevicePocket.aCoreSound.OpenOgg("resource/game_resource/london.ogg");
	aActionManager_.aDevicePocket.aCoreSound.Play(true);
}

void GameCore::run(){
	MSG msg;
	ZeroMemory( &msg, sizeof(msg) );
	while( msg.message != WM_QUIT ){
		if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) ){
			TranslateMessage( &msg );
			DispatchMessage( &msg );
		}else{

			//test Sound : need refactoring when M8
			aActionManager_.aDevicePocket.aCoreSound.Update();
			
			//RunMode : Process
			if(pControlTable_->runMode == ControlTable::PROCESS){
				aScriptManager_.process();
				aActionManager_.process();
				aRenderManager_.process();
				pControlTable_->aTimeController.excuteTimeController();

			//RunMode : Script
			}else if(pControlTable_->runMode == ControlTable::SCRIPT){
				aScriptManager_.controlScript();

			//RunMode : EXIT
			}else{
				msg.message = WM_QUIT;
			}
		}
	}
}