#include "CoreGraphic.h"

void CoreGraphic::initD3D(const HWND _hWnd, const int _width, const int _height, const bool _windowed){
	//construct D3D and set for D3DDevice
	if( NULL == ( pD3D_ = Direct3DCreate9( D3D_SDK_VERSION ) ) ){return;}
	pD3D_->GetAdapterDisplayMode( D3DADAPTER_DEFAULT, &aD3Ddm_ );
	ZeroMemory( &aD3Dpp_, sizeof(aD3Dpp_) );

	aD3Dpp_.Windowed = _windowed;
	//monitor ratio
	if (_windowed){monitorRatio_ = 1.333333f;}
	else{monitorRatio_ = (float)aD3Ddm_.Width/(float)aD3Ddm_.Height;}
	
	aD3Dpp_.SwapEffect = D3DSWAPEFFECT_DISCARD;
	aD3Dpp_.BackBufferFormat = aD3Ddm_.Format;
	aD3Dpp_.BackBufferWidth = _width;
	aD3Dpp_.BackBufferHeight = _height;
	aD3Dpp_.EnableAutoDepthStencil = TRUE;
	aD3Dpp_.AutoDepthStencilFormat = D3DFMT_D16;
	aD3Dpp_.PresentationInterval = D3DPRESENT_INTERVAL_IMMEDIATE;

	//construct D3DDevice
	if( FAILED( pD3D_->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, _hWnd,
                                        D3DCREATE_SOFTWARE_VERTEXPROCESSING,
										&aD3Dpp_, &pD3DDevice_ ) ) ){return;}
	//construct Sprite
	D3DXCreateSprite( pD3DDevice_, &pSprite_ );
	//,  , Ӽ, ڸ, charSet, Ȯ, ǰ, font_pitch, Ʈ̸
	D3DXFONT_DESC aFontDescFont00 = {12,0,400,0,false,DEFAULT_CHARSET,
								OUT_TT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_PITCH,""};
	D3DXCreateFontIndirect(pD3DDevice_,&aFontDescFont00,&pFont00_);

	D3DXFONT_DESC aFontDescFont01 = {24,0,400,0,false,DEFAULT_CHARSET,
								OUT_TT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_PITCH,"Arial"};
	D3DXCreateFontIndirect(pD3DDevice_,&aFontDescFont01,&pFont01_);
}

void CoreGraphic::setTextureOnlyPolygon(Model* _pModel){
	pD3DDevice_->SetTexture(0,_pModel->pTexture);
	pD3DDevice_->SetStreamSource(0,_pModel->pVB,0,sizeof(ModelVertex));
	pD3DDevice_->SetIndices(_pModel->pIB);
}

void CoreGraphic::drawPolygon(Model* _pModel){
	pD3DDevice_->DrawIndexedPrimitive(D3DPT_TRIANGLELIST,0,0,_pModel->numVertices,0, _pModel->numPolygons);
}

void CoreGraphic::camera(const float _fX, const float _fY, const float _fZ){
	//view matrix
	D3DXMatrixLookAtLH( &matView_, &vEyePt_, &vLookatPt_, &vUpVec_ );
	pD3DDevice_->SetTransform( D3DTS_VIEW, &matView_ );

	//projection matrix
	D3DXMatrixPerspectiveFovLH( &matProj_, D3DX_PI/4, monitorRatio_, 1.0f, 1000.0f );
	pD3DDevice_->SetTransform( D3DTS_PROJECTION, &matProj_ );
}
