/// @file WindowCore.h
#ifndef WINDOWCORE_H
#define WINDOWCORE_H

#include "../resource/resource.h"
#include <Windows.h>
LRESULT CALLBACK MsgProc(HWND hWnd, UINT iMsg, WPARAM wParam, LPARAM lParam);

/**
	@brief   Ŭ

	 ġ ϴ ŬԴϴ.\n
	initԼ makeԼ ϴ.
	Ϲ initԼ ʱȭ ʿ ü ʱȭϴ Լ ǹմϴ.\n
	 make λ ϴ Լ  ü ؼ ( ͸) ִ ԼԴϴ.
*/
class WindowCore {
	public:
		//set default
		WindowCore() : pClass_("END1"), pWindowCaption_("END1"){	
			wc_.cbSize = sizeof(WNDCLASSEX);
			wc_.style = CS_CLASSDC;
			wc_.lpfnWndProc = MsgProc;
			wc_.cbClsExtra = 0L;
			wc_.cbWndExtra = 0L;
			wc_.hInstance = GetModuleHandle(NULL);
			//wc_.hbrBackground = (HBRUSH)GetStockObject(WHITE_BRUSH);
			wc_.hbrBackground = NULL;
			wc_.hCursor = NULL;
			wc_.lpszMenuName = NULL;
			wc_.lpszClassName = pClass_;
		}
		~WindowCore(){
			UnregisterClass( pClass_, wc_.hInstance );
		}

		void initWindow(const int _width, const int _height){
			width_ = _width;
			height_ = _height;
			wc_.hIcon   = LoadIcon(wc_.hInstance, (LPCTSTR)IDI_ICON1);
			wc_.hIconSm = LoadIcon(wc_.hInstance, (LPCTSTR)IDI_ICON1);
			RegisterClassEx( &wc_ );
		}

		//make GameWindow
		HWND makeGameWindow(){
			RECT rt = { 0, 0, width_, height_ };
			AdjustWindowRect( &rt, WS_OVERLAPPEDWINDOW, false );
			//usual window style is WS_OVERLAPPEDWINDOW
			hWnd_ = CreateWindow( pClass_, pWindowCaption_, WS_VISIBLE | WS_SYSMENU | WS_MINIMIZEBOX,
                                 CW_USEDEFAULT, CW_USEDEFAULT, rt.right-rt.left, rt.bottom-rt.top,
                                 GetDesktopWindow(), NULL, wc_.hInstance, NULL );
			ShowWindow( hWnd_, SW_SHOWDEFAULT );
			return hWnd_;
		}

		//default runPeekMessage
		void runPeekMessage(){
			MSG msg;
			ZeroMemory( &msg, sizeof(msg) );
			while( msg.message != WM_QUIT ){
				if( PeekMessage( &msg, NULL, 0U, 0U, PM_REMOVE ) ){
					TranslateMessage( &msg );
					DispatchMessage( &msg );
				}else{
				}
			}
		}

		//default runGetMessage
		void runGesMessage(){
			MSG msg;
			while( GetMessage(&msg, 0, 0, 0) ){
				TranslateMessage( &msg );
				DispatchMessage( &msg );
			}
		}

	private:
		int width_;
		int height_;
		char* pClass_;
		char* pWindowCaption_;
		WNDCLASSEX wc_;
		HWND hWnd_;
};

LRESULT CALLBACK MsgProc(HWND hWnd, UINT msg, WPARAM wParam, LPARAM lParam){
	switch(msg){
		case WM_DESTROY:
			PostQuitMessage(0);
			return 0;
	}
	return (DefWindowProc(hWnd, msg, wParam, lParam));
}

#endif