/*
 * Decompiled with CFR 0.152.
 */
package com.softmeca.util.io;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;

public class FileIoUtil {
    public static String readDataFromFile(String _filePath) throws IOException {
        if (!FileIoUtil.hasFile(_filePath)) {
            throw new FileNotFoundException("\ud30c\uc77c\uc744 \ucc3e\uc744 \uc218 \uc5c6\uc2b5\ub2c8\ub2e4. File name: " + _filePath);
        }
        File file = new File(_filePath);
        FileReader fileReader = new FileReader(file);
        StringWriter stringWriter = new StringWriter();
        char[] buffer = new char[1024];
        int count = 0;
        while ((count = fileReader.read(buffer)) != -1) {
            stringWriter.write(buffer, 0, count);
        }
        stringWriter.flush();
        return stringWriter.toString();
    }

    public static void saveDataToFile(String _directoryPath, String _fileName, String _fileData) throws IOException {
        _directoryPath = FileIoUtil.fileSeparatorAddOrNone(_directoryPath);
        FileIoUtil.directoryCreateOrNone(_directoryPath);
        try {
            File f = new File(String.valueOf(_directoryPath) + _fileName);
            f.createNewFile();
            FileWriter fw = new FileWriter(f);
            fw.write(_fileData);
            fw.flush();
            fw.close();
        }
        catch (IOException e) {
            throw new IOException("\ud30c\uc77c\uc5d0 \uc4f8\uc218 \uc5c6\uc2b5\ub2c8\ub2e4. File name: " + _directoryPath + _fileName);
        }
    }

    public static boolean hasFile(String _filePath) {
        File file = new File(_filePath);
        return file.exists();
    }

    public static boolean hasDirectory(String _directoryPath) {
        File directory = new File(_directoryPath);
        return directory.exists();
    }

    public static boolean directoryCreateOrNone(String _directoryPath) {
        if (!FileIoUtil.hasDirectory(_directoryPath)) {
            return new File(_directoryPath).mkdirs();
        }
        return false;
    }

    public static String fileSeparatorAddOrNone(String _directoryPath) {
        if (!_directoryPath.endsWith("/") && !_directoryPath.endsWith("\\")) {
            _directoryPath = String.valueOf(_directoryPath) + File.separator;
        }
        return _directoryPath;
    }

    public static boolean isAbsolutePath(String _path) {
        return new File(_path).isAbsolute();
    }
}

